/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequests;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

@Immutable
public interface FilteredAcknowledgementRequest
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static FilteredAcknowledgementRequest of(Set<AcknowledgementRequest> includes, @Nullable String filter) {
        return AcknowledgementRequests.newFilteredAcknowledgementRequest(includes, filter);
    }

    public static FilteredAcknowledgementRequest fromJson(JsonObject jsonObject) {
        return AcknowledgementRequests.filteredAcknowledgementRequestFromJson(jsonObject);
    }

    public Set<AcknowledgementRequest> getIncludes();

    public Optional<String> getFilter();

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<JsonArray> INCLUDES = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"includes", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> FILTER = JsonFactory.newStringFieldDefinition((CharSequence)"filter", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        JsonFields() {
            throw new AssertionError();
        }
    }
}

