/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.acks;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;

@Immutable
final class ImmutableAcknowledgementLabel
implements AcknowledgementLabel {
    private final String label;

    private ImmutableAcknowledgementLabel(String label) {
        this.label = label;
    }

    static ImmutableAcknowledgementLabel of(CharSequence label) {
        return new ImmutableAcknowledgementLabel(label.toString());
    }

    @Override
    public int length() {
        return this.label.length();
    }

    @Override
    public char charAt(int index) {
        return this.label.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.label.substring(start, end);
    }

    public boolean equals(@Nullable Object o) {
        Class<?> otherClass;
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        Class<?> thisClass = this.getClass();
        if (thisClass == (otherClass = o.getClass())) {
            ImmutableAcknowledgementLabel that = (ImmutableAcknowledgementLabel)o;
            return Objects.equals(this.label, that.label);
        }
        Class<?>[] otherInterfaces = otherClass.getInterfaces();
        for (Class<?> thisInterface : thisClass.getInterfaces()) {
            if (ImmutableAcknowledgementLabel.contains(otherInterfaces, thisInterface)) continue;
            return false;
        }
        return Objects.equals(this.toString(), o.toString());
    }

    private static boolean contains(Class<?>[] interfaceClasses, Class<?> searchedInterfaceClass) {
        for (Class<?> interfaceClass : interfaceClasses) {
            if (interfaceClass != searchedInterfaceClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    @Override
    public String toString() {
        return this.label;
    }
}

