/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.auth;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContextType;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

@Immutable
public interface AuthorizationContext
extends Iterable<AuthorizationSubject>,
Jsonifiable.WithPredicate<JsonObject, JsonField> {
    public static AuthorizationContext newInstance(AuthorizationContextType type, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return AuthorizationModelFactory.newAuthContext(type, authorizationSubject, furtherAuthorizationSubjects);
    }

    public static AuthorizationContext newInstance(AuthorizationContextType type, Iterable<AuthorizationSubject> authorizationSubjects) {
        return AuthorizationModelFactory.newAuthContext(type, authorizationSubjects);
    }

    @Deprecated
    public static AuthorizationContext newInstance(AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return AuthorizationModelFactory.newAuthContext(authorizationSubject, furtherAuthorizationSubjects);
    }

    public AuthorizationContextType getType();

    public List<AuthorizationSubject> getAuthorizationSubjects();

    public AuthorizationContext addHead(List<AuthorizationSubject> var1);

    public AuthorizationContext addTail(List<AuthorizationSubject> var1);

    default public List<String> getAuthorizationSubjectIds() {
        return this.getAuthorizationSubjects().stream().map(AuthorizationSubject::getId).collect(Collectors.toList());
    }

    public Optional<AuthorizationSubject> getFirstAuthorizationSubject();

    public int getSize();

    public boolean isEmpty();

    public Stream<AuthorizationSubject> stream();

    public boolean isAuthorized(Collection<AuthorizationSubject> var1, Collection<AuthorizationSubject> var2);

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Immutable
    public static final class JsonFields {
        @Deprecated
        public static final JsonFieldDefinition<Integer> JSON_SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> AUTH_SUBJECTS = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"subjects", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

