/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.auth;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;

@Immutable
public abstract class AuthorizationContextType
implements CharSequence,
Comparable<AuthorizationContextType> {
    private final String type;

    protected AuthorizationContextType(String type) {
        this.type = ConditionChecker.argumentNotEmpty(type, "type");
    }

    @Override
    public int length() {
        return this.type.length();
    }

    @Override
    public char charAt(int index) {
        return this.type.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.type.subSequence(start, end);
    }

    @Override
    public int compareTo(AuthorizationContextType authorizationContextType) {
        return this.toString().compareTo(authorizationContextType.toString());
    }

    public final boolean equals(@Nullable Object o) {
        Class<?> otherClass;
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        Class<?> thisClass = this.getClass();
        if (thisClass == (otherClass = o.getClass())) {
            AuthorizationContextType that = (AuthorizationContextType)o;
            return Objects.equals(this.type, that.type);
        }
        Class<?>[] otherInterfaces = otherClass.getInterfaces();
        for (Class<?> thisInterface : thisClass.getInterfaces()) {
            if (AuthorizationContextType.contains(otherInterfaces, thisInterface)) continue;
            return false;
        }
        return Objects.equals(this.toString(), o.toString());
    }

    private static boolean contains(Class<?>[] interfaceClasses, Class<?> searchedInterfaceClass) {
        for (Class<?> interfaceClass : interfaceClasses) {
            if (interfaceClass != searchedInterfaceClass) continue;
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public final String toString() {
        return this.type;
    }
}

