/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.auth;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationContextType;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.model.base.auth.ImmutableAuthorizationContext;
import org.eclipse.ditto.model.base.auth.ImmutableAuthorizationSubject;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;

@Immutable
public final class AuthorizationModelFactory {
    private AuthorizationModelFactory() {
        throw new AssertionError();
    }

    public static AuthorizationSubject newAuthSubject(CharSequence identifier) {
        return ImmutableAuthorizationSubject.of(identifier);
    }

    public static AuthorizationContext emptyAuthContext() {
        return ImmutableAuthorizationContext.of(DittoAuthorizationContextType.UNSPECIFIED, Collections.emptyList());
    }

    public static AuthorizationContext newAuthContext(AuthorizationContextType type, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return ImmutableAuthorizationContext.of(type, authorizationSubject, furtherAuthorizationSubjects);
    }

    @Deprecated
    public static AuthorizationContext newAuthContext(AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        return ImmutableAuthorizationContext.of(DittoAuthorizationContextType.UNSPECIFIED, authorizationSubject, furtherAuthorizationSubjects);
    }

    public static AuthorizationContext newAuthContext(JsonObject jsonObject) {
        return DittoJsonException.wrapJsonRuntimeException(() -> ImmutableAuthorizationContext.fromJson(jsonObject));
    }

    public static AuthorizationContext newAuthContext(AuthorizationContextType type, Iterable<AuthorizationSubject> authorizationSubjects) {
        ArrayList<AuthorizationSubject> authSubjectsList = new ArrayList<AuthorizationSubject>();
        authorizationSubjects.forEach(authSubjectsList::add);
        return ImmutableAuthorizationContext.of(type, authSubjectsList);
    }

    @Deprecated
    public static AuthorizationContext newAuthContext(Iterable<AuthorizationSubject> authorizationSubjects) {
        ArrayList<AuthorizationSubject> authSubjectsList = new ArrayList<AuthorizationSubject>();
        authorizationSubjects.forEach(authSubjectsList::add);
        return ImmutableAuthorizationContext.of(DittoAuthorizationContextType.UNSPECIFIED, authSubjectsList);
    }
}

