/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.auth;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;

@Immutable
final class ImmutableAuthorizationSubject
implements AuthorizationSubject {
    private final String id;

    private ImmutableAuthorizationSubject(CharSequence theId) {
        this.id = theId.toString();
    }

    public static ImmutableAuthorizationSubject of(CharSequence id) {
        String argumentName = "identifier of the new authorization subject";
        ConditionChecker.checkNotNull(id, "identifier of the new authorization subject");
        ConditionChecker.checkNotEmpty(id, "identifier of the new authorization subject");
        return new ImmutableAuthorizationSubject(id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAuthorizationSubject that = (ImmutableAuthorizationSubject)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.getId();
    }
}

