/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.common;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;

@NotThreadSafe
public final class BinaryValidationResult {
    @Nullable
    private final Throwable reasonForInvalidity;

    private BinaryValidationResult(@Nullable Throwable reasonForInvalidity) {
        this.reasonForInvalidity = reasonForInvalidity;
    }

    public static BinaryValidationResult valid() {
        return new BinaryValidationResult(null);
    }

    public static BinaryValidationResult invalid(Throwable reasonForInvalidity) {
        return new BinaryValidationResult(ConditionChecker.checkNotNull(reasonForInvalidity, "reasonForInvalidity"));
    }

    public boolean isValid() {
        return this.reasonForInvalidity == null;
    }

    @Nullable
    public Throwable getReasonForInvalidity() {
        return this.reasonForInvalidity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryValidationResult that = (BinaryValidationResult)o;
        return Objects.equals(this.reasonForInvalidity, that.reasonForInvalidity);
    }

    public int hashCode() {
        return Objects.hash(this.reasonForInvalidity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [reasonForInvalidity=" + this.reasonForInvalidity + "]";
    }
}

