/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CharsetDeterminer
implements Function<CharSequence, Charset> {
    private static final Pattern CHARSET_PATTERN = Pattern.compile(";.?charset=");
    @Nullable
    private static CharsetDeterminer instance = null;

    private CharsetDeterminer() {
    }

    public static CharsetDeterminer getInstance() {
        CharsetDeterminer result = instance;
        if (null == result) {
            instance = result = new CharsetDeterminer();
        }
        return result;
    }

    @Override
    public Charset apply(@Nullable CharSequence contentType) {
        String[] withCharset;
        if (null != contentType && 2 == (withCharset = CHARSET_PATTERN.split(contentType, 2)).length && Charset.isSupported(withCharset[1])) {
            return Charset.forName(withCharset[1]);
        }
        return StandardCharsets.UTF_8;
    }
}

