/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.common;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ConditionChecker {
    private ConditionChecker() {
        throw new AssertionError();
    }

    public static <T> T checkNotNull(@Nullable T argument) {
        return Objects.requireNonNull(argument, () -> null);
    }

    public static <T> T checkNotNull(@Nullable T argument, String argumentName) {
        return Objects.requireNonNull(argument, () -> MessageFormat.format("The {0} must not be null!", argumentName));
    }

    public static <T extends CharSequence> T checkNotEmpty(T argument, String argumentName) {
        if (0 == argument.length()) {
            throw new IllegalArgumentException(MessageFormat.format("The {0} must not be empty!", argumentName));
        }
        return argument;
    }

    public static <T extends Collection> T checkNotEmpty(T argument, String argumentName) {
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("The {0} must not be empty!", argumentName));
        }
        return argument;
    }

    @Nullable
    public static <T> T checkArgument(@Nullable T argument, Predicate<T> argumentPredicate) {
        if (!argumentPredicate.test(argument)) {
            throw new IllegalArgumentException("The argument is invalid!");
        }
        return argument;
    }

    @Nullable
    public static <T> T checkArgument(@Nullable T argument, Predicate<T> argumentPredicate, Supplier<String> messageSupplier) {
        if (!argumentPredicate.test(argument)) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return argument;
    }

    public static <T> T argumentNotNull(@Nullable T argument) {
        return (T)ConditionChecker.checkArgument(argument, Objects::nonNull, () -> "The argument must not be null!");
    }

    public static <T> T argumentNotNull(@Nullable T argument, String argumentName) {
        return (T)ConditionChecker.checkArgument(argument, Objects::nonNull, () -> MessageFormat.format("The argument ''{0}'' must not be null!", argumentName));
    }

    public static <T extends CharSequence> T argumentNotEmpty(T argument) {
        ConditionChecker.checkNotNull(argument);
        return (T)ConditionChecker.checkArgument(argument, s -> 0 < s.length(), () -> "The char sequence argument must not be empty!");
    }

    public static <T extends CharSequence> T argumentNotEmpty(T argument, String argumentName) {
        ConditionChecker.checkNotNull(argument, argumentName);
        return (T)ConditionChecker.checkArgument(argument, s -> 0 < s.length(), () -> MessageFormat.format("The argument ''{0}'' must not be empty!", argumentName));
    }

    public static <T extends Collection> T argumentNotEmpty(T argument) {
        ConditionChecker.checkNotNull(argument);
        return (T)ConditionChecker.checkArgument(argument, c -> !c.isEmpty(), () -> "The collection argument must not be empty!");
    }

    public static <T extends Collection> T argumentNotEmpty(T argument, String argumentName) {
        ConditionChecker.checkNotNull(argument, argumentName);
        return (T)ConditionChecker.checkArgument(argument, c -> !c.isEmpty(), () -> MessageFormat.format("The argument ''{0}'' must not be empty!", argumentName));
    }
}

