/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.common;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.Validator;

@Immutable
public final class IdValidator
implements Validator {
    private final CharSequence id;
    private final Pattern idPattern;
    private String reason;

    private IdValidator(@Nullable CharSequence id, String regex) {
        this.id = id;
        this.idPattern = Pattern.compile(regex);
        this.reason = null;
    }

    public static IdValidator newInstance(@Nullable CharSequence id, String regex) {
        Objects.requireNonNull(regex, "The regex to be validated against must not be null!");
        return new IdValidator(id, regex);
    }

    @Override
    public boolean isValid() {
        boolean isValid;
        if (this.id == null) {
            isValid = false;
            this.reason = "The ID is not valid because it was 'null'!";
        } else {
            Matcher matcher = this.idPattern.matcher(this.id);
            isValid = matcher.matches();
            if (!isValid) {
                String msgTemplate = "The ID ''{0}'' is not valid! It did not match the pattern ''{1}''.";
                this.reason = MessageFormat.format("The ID ''{0}'' is not valid! It did not match the pattern ''{1}''.", this.id, this.idPattern);
            }
        }
        return isValid;
    }

    @Override
    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }
}

