/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.common;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Placeholders {
    private static final String PLACEHOLDER_GROUP_NAME = "p";
    private static final String LEGACY_PLACEHOLDER_GROUP_NAME = "l";
    private static final String LEGACY_PLACEHOLDER_SUBJECT_ID_GROUP_NAME = "s";
    private static final String PLACEHOLDER_START = Pattern.quote("{{");
    private static final String PLACEHOLDER_END = Pattern.quote("}}");
    private static final String PLACEHOLDER_GROUP = "(?<p>((}[^}]|[^}])*+))";
    private static final String LEGACY_PLACEHOLDER_GROUP = "(?<l>([^}]*+))";
    private static final String ANY_NUMBER_OF_SPACES = "\\s*+";
    private static final String PLACEHOLDER_REGEX = PLACEHOLDER_START + "\\s*+" + "(?<p>((}[^}]|[^}])*+))" + "\\s*+" + PLACEHOLDER_END;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_REGEX);
    private static final String LEGACY_PLACEHOLDER_START = Pattern.quote("${");
    private static final String LEGACY_PLACEHOLDER_END = Pattern.quote("}");
    private static final String LEGACY_PLACEHOLDER_REGEX = LEGACY_PLACEHOLDER_START + "(?<l>([^}]*+))" + LEGACY_PLACEHOLDER_END;
    private static final Pattern LEGACY_PLACEHOLDER_PATTERN = Pattern.compile(LEGACY_PLACEHOLDER_REGEX);
    private static final Pattern ANY_PLACEHOLDER_PATTERN = Pattern.compile("(?:" + PLACEHOLDER_REGEX + "|" + LEGACY_PLACEHOLDER_REGEX + ")");

    private Placeholders() {
        throw new AssertionError();
    }

    public static Pattern pattern() {
        return ANY_PLACEHOLDER_PATTERN;
    }

    public static List<String> groupNames() {
        return Arrays.asList(PLACEHOLDER_GROUP_NAME, LEGACY_PLACEHOLDER_GROUP_NAME, LEGACY_PLACEHOLDER_SUBJECT_ID_GROUP_NAME);
    }

    public static boolean containsAnyPlaceholder(CharSequence input) {
        Objects.requireNonNull(input);
        return Placeholders.containsPlaceholder(input) || Placeholders.containsLegacyPlaceholder(input);
    }

    private static boolean containsPlaceholder(CharSequence input) {
        Objects.requireNonNull(input);
        return PLACEHOLDER_PATTERN.matcher(input).find();
    }

    private static boolean containsLegacyPlaceholder(CharSequence input) {
        Objects.requireNonNull(input);
        return LEGACY_PLACEHOLDER_PATTERN.matcher(input).find();
    }
}

