/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.entity.Revision;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

@Immutable
public interface Entity<T extends Revision<T>>
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    @Deprecated
    default public Optional<String> getId() {
        return this.getEntityId().map(String::valueOf);
    }

    public Optional<? extends EntityId> getEntityId();

    public Optional<T> getRevision();

    public Optional<Instant> getModified();

    public Optional<Instant> getCreated();

    public Optional<Metadata> getMetadata();

    public boolean isDeleted();

    @Override
    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }
}

