/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.id;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.EntityId;

@Immutable
public final class DefaultEntityId
implements EntityId {
    private static final DefaultEntityId DUMMY_ID = DefaultEntityId.of(":_");
    private final String id;

    private DefaultEntityId(CharSequence id) {
        this.id = ConditionChecker.argumentNotEmpty(id, "entityId").toString();
    }

    public static DefaultEntityId of(CharSequence entityId) {
        if (entityId instanceof DefaultEntityId) {
            return (DefaultEntityId)entityId;
        }
        return new DefaultEntityId(entityId);
    }

    public static DefaultEntityId generateRandom() {
        return new DefaultEntityId(UUID.randomUUID().toString());
    }

    public static DefaultEntityId dummy() {
        return DUMMY_ID;
    }

    @Override
    public boolean isDummy() {
        return DUMMY_ID.equals(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEntityId that = (DefaultEntityId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        return this.id;
    }
}

