/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.id;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityId;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdInvalidException;
import org.eclipse.ditto.model.base.entity.validation.EntityIdPatternValidator;

@Immutable
public final class DefaultNamespacedEntityId
implements NamespacedEntityId {
    private static final NamespacedEntityId DUMMY_ID = DefaultNamespacedEntityId.of(":_");
    private static final String DEFAULT_NAMESPACE = "";
    private final String namespace;
    private final String name;
    private final String stringRepresentation;

    private DefaultNamespacedEntityId(String namespace, String name, boolean shouldValidate) {
        this.stringRepresentation = shouldValidate ? this.validate(namespace, name) : namespace + ":" + name;
        this.namespace = namespace;
        this.name = name;
    }

    private DefaultNamespacedEntityId(@Nullable CharSequence entityId) {
        if (entityId == null) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(entityId).build();
        }
        EntityIdPatternValidator validator = EntityIdPatternValidator.getInstance(entityId);
        if (!validator.isValid()) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(entityId).build();
        }
        String[] elements = entityId.toString().split(":", 2);
        this.namespace = elements[0];
        this.name = elements[1];
        this.stringRepresentation = entityId.toString();
    }

    public static NamespacedEntityId of(CharSequence entityId) {
        if (entityId instanceof DefaultNamespacedEntityId) {
            return (NamespacedEntityId)entityId;
        }
        if (entityId instanceof NamespacedEntityId) {
            String namespace = ((NamespacedEntityId)entityId).getNamespace();
            String name = ((NamespacedEntityId)entityId).getName();
            return new DefaultNamespacedEntityId(namespace, name, false);
        }
        return new DefaultNamespacedEntityId(entityId);
    }

    public static NamespacedEntityId fromName(String entityName) {
        return DefaultNamespacedEntityId.of(DEFAULT_NAMESPACE, entityName);
    }

    public static NamespacedEntityId of(String namespace, String name) {
        return new DefaultNamespacedEntityId(namespace, name, true);
    }

    public static NamespacedEntityId dummy() {
        return DUMMY_ID;
    }

    private String validate(@Nullable String namespace, @Nullable String name) {
        String sp = namespace + ":" + name;
        if (namespace == null || name == null || !EntityIdPatternValidator.getInstance(sp).isValid()) {
            throw (NamespacedEntityIdInvalidException)NamespacedEntityIdInvalidException.newBuilder(sp).build();
        }
        return sp;
    }

    @Override
    public boolean isDummy() {
        return DUMMY_ID.equals(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNamespacedEntityId that = (DefaultNamespacedEntityId)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }
}

