/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.id;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.entity.type.WithEntityType;

@Immutable
public abstract class EntityIdWithType
implements EntityId,
WithEntityType {
    private final EntityId entityId;

    protected EntityIdWithType(EntityId entityId) {
        this.entityId = ConditionChecker.checkNotNull(entityId, "entityId");
    }

    @Deprecated
    public static <I extends EntityIdWithType> Consumer<I> createEqualityValidator(I expectedEntityId) {
        return expectedEntityId::isCompatibleOrThrow;
    }

    public boolean isCompatibleOrThrow(@Nullable EntityIdWithType otherEntityId) {
        if (!this.equals(otherEntityId)) {
            throw this.getIllegalArgumentExceptionForDifferentEntityIds(otherEntityId);
        }
        return true;
    }

    protected IllegalArgumentException getIllegalArgumentExceptionForDifferentEntityIds(@Nullable EntityIdWithType actual) {
        String pattern = "The entity ID <{0}> is not compatible with <{1}>!";
        return new IllegalArgumentException(MessageFormat.format("The entity ID <{0}> is not compatible with <{1}>!", actual, this));
    }

    @Override
    public boolean isDummy() {
        return this.entityId.isDummy();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityIdWithType that = (EntityIdWithType)o;
        return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.getEntityType(), that.getEntityType());
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.getEntityType());
    }

    @Override
    public String toString() {
        return this.entityId.toString();
    }
}

