/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.id;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@JsonParsableException(errorCode="namespacedentity.id.invalid")
@Immutable
public final class NamespacedEntityIdInvalidException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "namespacedentity.id.invalid";
    private static final String MESSAGE_TEMPLATE = "Namespaced entity ID ''{0}'' is not valid!";
    private static final String NAMESPACED_ENTITY_ID_DESCRIPTION = "It must conform to the namespaced entity ID notation (see Ditto documentation) with a maximum name length of 256 characters.";
    private static final URI DEFAULT_HREF = URI.create("https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id");
    private final CharSequence entityId;

    private NamespacedEntityIdInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href, @Nullable CharSequence entityId) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
        this.entityId = entityId;
    }

    public static Builder newBuilder(@Nullable CharSequence entityId) {
        return new Builder(entityId, NAMESPACED_ENTITY_ID_DESCRIPTION);
    }

    public static NamespacedEntityIdInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder((CharSequence)NamespacedEntityIdInvalidException.readEntityId(jsonObject).orElse(null)));
    }

    private static Optional<String> readEntityId(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "JSON object");
        return jsonObject.getValue(JsonFields.ENTITY_ID);
    }

    public Optional<CharSequence> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder(null).message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @Immutable
    public static final class JsonFields {
        static final JsonFieldDefinition<String> ENTITY_ID = JsonFactory.newStringFieldDefinition((CharSequence)"entityId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<NamespacedEntityIdInvalidException> {
        private final CharSequence entityId;

        private Builder(@Nullable CharSequence entityId) {
            this.entityId = entityId;
            this.message(MessageFormat.format(NamespacedEntityIdInvalidException.MESSAGE_TEMPLATE, entityId));
            this.href(DEFAULT_HREF);
        }

        private Builder(@Nullable CharSequence entityId, String description) {
            this(entityId);
            this.description(description);
        }

        @Override
        protected NamespacedEntityIdInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new NamespacedEntityIdInvalidException(dittoHeaders, message, description, cause, href, this.entityId);
        }
    }
}

