/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.id;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.entity.id.EntityIdWithType;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityId;

@Immutable
public abstract class NamespacedEntityIdWithType
extends EntityIdWithType
implements NamespacedEntityId {
    private final NamespacedEntityId namespacedEntityId;

    protected NamespacedEntityIdWithType(NamespacedEntityId namespacedEntityId) {
        super(namespacedEntityId);
        this.namespacedEntityId = namespacedEntityId;
    }

    @Override
    public String getNamespace() {
        return this.namespacedEntityId.getNamespace();
    }

    @Override
    public String getName() {
        return this.namespacedEntityId.getName();
    }

    @Override
    public boolean isCompatibleOrThrow(@Nullable EntityIdWithType otherEntityId) {
        boolean result = null == otherEntityId ? false : (this.equals(otherEntityId) ? true : (!Objects.equals(this.getEntityType(), otherEntityId.getEntityType()) ? false : (otherEntityId instanceof NamespacedEntityIdWithType ? this.isNamespaceAndNameCompatible((NamespacedEntityId)((Object)otherEntityId)) : false)));
        if (!result) {
            throw this.getIllegalArgumentExceptionForDifferentEntityIds(otherEntityId);
        }
        return result;
    }

    private boolean isNamespaceAndNameCompatible(NamespacedEntityId otherEntityId) {
        String otherNamespace;
        String namespace;
        boolean result = Objects.equals(this.getName(), otherEntityId.getName()) ? ((namespace = this.getNamespace()).equals(otherNamespace = otherEntityId.getNamespace()) ? true : namespace.isEmpty() || otherNamespace.isEmpty()) : false;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedEntityIdWithType that = (NamespacedEntityIdWithType)o;
        return Objects.equals(this.namespacedEntityId, that.namespacedEntityId) && Objects.equals(this.getEntityType(), that.getEntityType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.namespacedEntityId, this.getEntityType());
    }
}

