/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.metadata;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@Immutable
final class ImmutableMetadata
implements Metadata {
    private final JsonObject wrapped;

    private ImmutableMetadata(JsonObject toWrap) {
        this.wrapped = toWrap;
    }

    public static Metadata empty() {
        return new ImmutableMetadata(JsonFactory.newObject());
    }

    public static Metadata of(JsonObject jsonObject) {
        if (jsonObject instanceof ImmutableMetadata) {
            return (Metadata)jsonObject;
        }
        return new ImmutableMetadata(ConditionChecker.checkNotNull(jsonObject, "jsonObject"));
    }

    public boolean isBoolean() {
        return this.wrapped.isBoolean();
    }

    public boolean isNumber() {
        return this.wrapped.isNumber();
    }

    public boolean isInt() {
        return this.wrapped.isInt();
    }

    public boolean isLong() {
        return this.wrapped.isLong();
    }

    public boolean isDouble() {
        return this.wrapped.isDouble();
    }

    public boolean isString() {
        return this.wrapped.isString();
    }

    public boolean isObject() {
        return this.wrapped.isObject();
    }

    public boolean isArray() {
        return this.wrapped.isArray();
    }

    public boolean isNull() {
        return this.wrapped.isNull();
    }

    public boolean asBoolean() {
        return this.wrapped.asBoolean();
    }

    public int asInt() {
        return this.wrapped.asInt();
    }

    public long asLong() {
        return this.wrapped.asLong();
    }

    public double asDouble() {
        return this.wrapped.asDouble();
    }

    public String asString() {
        return this.wrapped.asString();
    }

    public JsonObject asObject() {
        return this.wrapped.asObject();
    }

    public JsonArray asArray() {
        return this.wrapped.asArray();
    }

    @Override
    public Metadata setValue(CharSequence key, int value) {
        return this.setValue(key, JsonFactory.newValue((int)value));
    }

    @Override
    public Metadata setValue(CharSequence key, long value) {
        return this.setValue(key, JsonFactory.newValue((long)value));
    }

    @Override
    public Metadata setValue(CharSequence key, double value) {
        return this.setValue(key, JsonFactory.newValue((double)value));
    }

    @Override
    public Metadata setValue(CharSequence key, boolean value) {
        return this.setValue(key, JsonFactory.newValue((boolean)value));
    }

    @Override
    public Metadata setValue(CharSequence key, String value) {
        return this.setValue(key, JsonFactory.newValue((String)value));
    }

    @Override
    public Metadata setValue(CharSequence key, JsonValue value) {
        return this.determineResult(() -> this.wrapped.setValue(key, value));
    }

    public <T> Metadata set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value) {
        return this.determineResult(() -> this.wrapped.set(fieldDefinition, value));
    }

    @Override
    public Metadata set(JsonField field) {
        return this.determineResult(() -> this.wrapped.set(field));
    }

    @Override
    public Metadata setAll(Iterable<JsonField> jsonFields) {
        return this.determineResult(() -> this.wrapped.setAll(jsonFields));
    }

    @Override
    public Metadata remove(CharSequence key) {
        return this.determineResult(() -> this.wrapped.remove(key));
    }

    public boolean contains(CharSequence key) {
        return this.wrapped.contains(key);
    }

    public JsonObject get(JsonPointer pointer) {
        return this.wrapped.get(pointer);
    }

    public JsonObject get(JsonFieldDefinition fieldDefinition) {
        return this.wrapped.get(fieldDefinition);
    }

    public <T> Optional<T> getValue(JsonFieldDefinition<T> fieldDefinition) {
        return this.wrapped.getValue(fieldDefinition);
    }

    public <T> T getValueOrThrow(JsonFieldDefinition<T> fieldDefinition) {
        return (T)this.wrapped.getValueOrThrow(fieldDefinition);
    }

    public JsonObject get(JsonFieldSelector fieldSelector) {
        return this.wrapped.get(fieldSelector);
    }

    public Optional<JsonValue> getValue(CharSequence key) {
        return this.wrapped.getValue(key);
    }

    public List<JsonKey> getKeys() {
        return this.wrapped.getKeys();
    }

    public Optional<JsonField> getField(CharSequence key) {
        return this.wrapped.getField(key);
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public int getSize() {
        return this.wrapped.getSize();
    }

    public Iterator<JsonField> iterator() {
        return this.wrapped.iterator();
    }

    public Stream<JsonField> stream() {
        return this.wrapped.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMetadata that = (ImmutableMetadata)o;
        return Objects.equals(this.wrapped, that.wrapped);
    }

    public int hashCode() {
        return Objects.hash(this.wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public void writeValue(SerializationContext serializationContext) throws IOException {
        this.wrapped.writeValue(serializationContext);
    }

    public long getUpperBoundForStringSize() {
        return this.wrapped.getUpperBoundForStringSize();
    }

    private Metadata determineResult(Supplier<JsonObject> newWrappedSupplier) {
        JsonObject newWrapped = newWrappedSupplier.get();
        if (!newWrapped.equals(this.wrapped)) {
            return ImmutableMetadata.of(newWrapped);
        }
        return this;
    }

    @Override
    public JsonObject toJson() {
        return this;
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return (JsonObject)this.stream().filter(field -> !field.getDefinition().isPresent() || predicate.test(field)).collect(JsonCollectors.fieldsToObject());
    }
}

