/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.metadata;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointerInvalidException;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.ImmutableMetadata;
import org.eclipse.ditto.model.base.entity.metadata.ImmutableMetadataBuilder;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.entity.metadata.MetadataBuilder;
import org.eclipse.ditto.model.base.entity.metadata.NullMetadata;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;

@Immutable
public final class MetadataModelFactory {
    private static final Pattern METADATA_POINTER_PATTERN = Pattern.compile("^[^/].*[^/]$|[^/]");

    private MetadataModelFactory() {
        throw new AssertionError();
    }

    public static Metadata emptyMetadata() {
        return ImmutableMetadata.empty();
    }

    public static Metadata nullMetadata() {
        return NullMetadata.newInstance();
    }

    public static Metadata newMetadata(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "JSON object for initialization");
        if (!jsonObject.isNull()) {
            for (JsonKey key : jsonObject.getKeys()) {
                Matcher matcher = METADATA_POINTER_PATTERN.matcher((CharSequence)key);
                if (matcher.matches()) continue;
                throw (JsonPointerInvalidException)JsonPointerInvalidException.newBuilderForOuterSlashes((CharSequence)key).build();
            }
            return ImmutableMetadata.of(jsonObject);
        }
        return MetadataModelFactory.nullMetadata();
    }

    public static Metadata newMetadata(String jsonString) {
        JsonObject jsonObject = DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return MetadataModelFactory.newMetadata(jsonObject);
    }

    public static MetadataBuilder newMetadataBuilder() {
        return ImmutableMetadataBuilder.empty();
    }

    public static MetadataBuilder newMetadataBuilder(Metadata metadata) {
        return ImmutableMetadataBuilder.of(metadata);
    }
}

