/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.SerializationContext;
import org.eclipse.ditto.model.base.entity.metadata.ImmutableMetadata;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@Immutable
final class NullMetadata
implements Metadata {
    private static final String NOT_A_NUMBER = "This JSON value is not a number: ";
    private final JsonObject wrapped = JsonFactory.nullObject();

    private NullMetadata() {
    }

    public static Metadata newInstance() {
        return new NullMetadata();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNull() {
        return true;
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("This JSON value is not a boolean: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException(NOT_A_NUMBER + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException("This JSON value is not a string: " + this.toString());
    }

    public JsonObject asObject() {
        return this;
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("This JSON value is not an array: " + this.toString());
    }

    @Override
    public Metadata setValue(CharSequence name, int value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(name, value));
    }

    @Override
    public Metadata setValue(CharSequence name, long value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(name, value));
    }

    @Override
    public Metadata setValue(CharSequence name, double value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(name, value));
    }

    @Override
    public Metadata setValue(CharSequence key, boolean value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(key, value));
    }

    @Override
    public Metadata setValue(CharSequence name, String value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(name, value));
    }

    @Override
    public Metadata setValue(CharSequence name, JsonValue value) {
        return ImmutableMetadata.of(JsonFactory.newObject().setValue(name, value));
    }

    public <T> Metadata set(JsonFieldDefinition<T> fieldDefinition, @Nullable T value) {
        return ImmutableMetadata.of(JsonFactory.newObject().set(fieldDefinition, value));
    }

    @Override
    public Metadata set(JsonField field) {
        return ImmutableMetadata.of(JsonFactory.newObject().set(field));
    }

    @Override
    public Metadata setAll(Iterable<JsonField> jsonFields) {
        return ImmutableMetadata.of(JsonFactory.newObject().setAll(jsonFields));
    }

    public boolean contains(CharSequence key) {
        return false;
    }

    public Optional<JsonValue> getValue(CharSequence name) {
        return Optional.empty();
    }

    public JsonObject get(JsonPointer pointer) {
        return this;
    }

    public JsonObject get(JsonFieldDefinition fieldDefinition) {
        return this;
    }

    public <T> Optional<T> getValue(JsonFieldDefinition<T> fieldDefinition) {
        return Optional.empty();
    }

    public <T> T getValueOrThrow(JsonFieldDefinition<T> fieldDefinition) {
        throw new JsonMissingFieldException((CharSequence)fieldDefinition.getPointer());
    }

    public JsonObject get(JsonFieldSelector fieldSelector) {
        return this;
    }

    @Override
    public Metadata remove(CharSequence key) {
        return this;
    }

    public List<JsonKey> getKeys() {
        return Collections.emptyList();
    }

    public Optional<JsonField> getField(CharSequence key) {
        return Optional.empty();
    }

    public Iterator<JsonField> iterator() {
        return Collections.emptyIterator();
    }

    public boolean isEmpty() {
        return true;
    }

    public int getSize() {
        return 0;
    }

    public Stream<JsonField> stream() {
        return Stream.empty();
    }

    @Override
    public JsonObject toJson() {
        return this.wrapped;
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        return this.wrapped;
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return this.wrapped;
    }

    public int hashCode() {
        return Objects.hash(this.wrapped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullMetadata other = (NullMetadata)o;
        return Objects.equals(this.wrapped, other.wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public void writeValue(SerializationContext serializationContext) throws IOException {
        JsonFactory.nullLiteral().writeValue(serializationContext);
    }

    public long getUpperBoundForStringSize() {
        return JsonFactory.nullLiteral().getUpperBoundForStringSize();
    }
}

