/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.entity.type;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.type.EntityType;

@Immutable
final class DefaultEntityType
implements EntityType {
    private final String value;

    private DefaultEntityType(CharSequence value) {
        this.value = value.toString();
    }

    public static DefaultEntityType of(CharSequence value) {
        return new DefaultEntityType(ConditionChecker.argumentNotEmpty(value, "value"));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEntityType that = (DefaultEntityType)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int compareTo(EntityType o) {
        ConditionChecker.checkNotNull(o, "o");
        return this.value.compareTo(o.toString());
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

