/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="cloudevent.unparsable")
@Immutable
public final class CloudEventNotParsableException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "cloudevent.unparsable";
    private static final String DEFAULT_MESSAGE = "Unable to parse as Cloud Event.";
    private static final String MESSAGE_PATTERN = "Unable to parse as Cloud Event because of: <{0}>";
    private static final String DESCRIPTION = "Ensure that the event is being transmitted according to the Cloud Events HTTP binding specification v1.0 and that all mandatory headers were set.";
    private static final URI DEFAULT_URI = URI.create("https://github.com/cloudevents/spec/blob/v1.0/http-protocol-binding.md");
    private static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;

    private CloudEventNotParsableException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HTTP_STATUS, dittoHeaders, message, description, cause, href == null ? DEFAULT_URI : href);
    }

    public static DittoRuntimeExceptionBuilder<CloudEventNotParsableException> withDetailedInformationBuilder(String details) {
        String msgPattern = MessageFormat.format(MESSAGE_PATTERN, details);
        return new Builder().message(msgPattern).description(DESCRIPTION);
    }

    public static CloudEventNotParsableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CloudEventNotParsableException> {
        private Builder() {
            this.message(CloudEventNotParsableException.DEFAULT_MESSAGE);
        }

        @Override
        protected CloudEventNotParsableException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CloudEventNotParsableException(dittoHeaders, message, description, cause, href);
        }
    }
}

