/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="cloudevent.dataschema.unsupported")
@Immutable
public final class CloudEventUnsupportedDataSchemaException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "cloudevent.dataschema.unsupported";
    private static final String DEFAULT_MESSAGE = "The provided Cloud Event dataschema is not supported for this resource.";
    private static final String MESSAGE_PATTERN = "The provided Cloud Event dataschema <{0}> is not supported for this resource.";
    private static final String DESCRIPTION = "Ensure that the URI's scheme is 'ditto', so the complete dataschema starts with 'ditto:'";
    private static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;

    private CloudEventUnsupportedDataSchemaException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HTTP_STATUS, dittoHeaders, message, description, cause, href);
    }

    public static DittoRuntimeExceptionBuilder<CloudEventUnsupportedDataSchemaException> withDetailedInformationBuilder(String callersDataSchema) {
        String msgPattern = MessageFormat.format(MESSAGE_PATTERN, callersDataSchema);
        return new Builder().message(msgPattern).description(DESCRIPTION);
    }

    public static CloudEventUnsupportedDataSchemaException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<CloudEventUnsupportedDataSchemaException> {
        private Builder() {
            this.message(CloudEventUnsupportedDataSchemaException.DEFAULT_MESSAGE);
        }

        @Override
        protected CloudEventUnsupportedDataSchemaException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new CloudEventUnsupportedDataSchemaException(dittoHeaders, message, description, cause, href);
        }
    }
}

