/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="header.invalid")
@Immutable
public final class DittoHeaderInvalidException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "header.invalid";
    private static final String DEFAULT_MESSAGE = "The value of a header is invalid.";
    private static final String MESSAGE_TEMPLATE = "The value ''{0}'' of the header ''{1}'' is not a valid {2}.";
    private static final String DEFAULT_DESCRIPTION = "Verify that the header has the correct syntax and try again.";
    private static final String DESCRIPTION_TEMPLATE = "Verify that the value of the header ''{0}'' is a valid ''{1}'' and try again.";
    private static final long serialVersionUID = -2338222496153977081L;

    private DittoHeaderInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newInvalidTypeBuilder(String headerName, @Nullable CharSequence headerValue, String headerType) {
        return new Builder(headerName, headerValue, headerType);
    }

    public static Builder newInvalidTypeBuilder(HeaderDefinition headerDefinition, @Nullable CharSequence headerValue, String headerType) {
        return new Builder(headerDefinition.getKey(), headerValue, headerType);
    }

    public static Builder newCustomMessageBuilder(String customMessage) {
        return new Builder(customMessage);
    }

    public static DittoHeaderInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoHeaderInvalidException> {
        private Builder() {
            this.message(DittoHeaderInvalidException.DEFAULT_MESSAGE);
            this.description(DittoHeaderInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String headerName, @Nullable CharSequence headerValue, String headerType) {
            this.message(MessageFormat.format(DittoHeaderInvalidException.MESSAGE_TEMPLATE, String.valueOf(headerValue), Objects.requireNonNull(headerName), Objects.requireNonNull(headerType)));
            this.description(MessageFormat.format(DittoHeaderInvalidException.DESCRIPTION_TEMPLATE, headerName, headerType));
        }

        private Builder(String customMessage) {
            this();
            this.message(customMessage);
        }

        @Override
        protected DittoHeaderInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoHeaderInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

