/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="headers.too.large")
@Immutable
public final class DittoHeadersTooLargeException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "headers.too.large";
    private static final String DEFAULT_MESSAGE = "The headers are too large.";

    private DittoHeadersTooLargeException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, dittoHeaders, message, description, cause, href);
    }

    public static DittoRuntimeExceptionBuilder<DittoHeadersTooLargeException> newSizeLimitBuilder(long maxSize) {
        String msgPattern = "The number of bytes exceeded the maximum allowed value <{0}>!";
        return new Builder().description(MessageFormat.format("The number of bytes exceeded the maximum allowed value <{0}>!", maxSize));
    }

    public static DittoRuntimeExceptionBuilder<DittoHeadersTooLargeException> newAuthSubjectsLimitBuilder(int actualAuthSubjectCount, int maxAuthSubjectsCount) {
        String msgPtrn = "The number of authorization subjects <{0}> exceeded the maximum allowed value <{1}>.";
        return new Builder().description(MessageFormat.format("The number of authorization subjects <{0}> exceeded the maximum allowed value <{1}>.", actualAuthSubjectCount, maxAuthSubjectsCount));
    }

    public static DittoHeadersTooLargeException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    private static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoHeadersTooLargeException> {
        private Builder() {
            this.message(DittoHeadersTooLargeException.DEFAULT_MESSAGE);
        }

        @Override
        protected DittoHeadersTooLargeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoHeadersTooLargeException(dittoHeaders, message, description, cause, href);
        }
    }
}

