/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.ditto.json.JsonException;
import org.eclipse.ditto.json.JsonRuntimeException;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;

public final class DittoJsonException
extends DittoRuntimeException {
    public static final String FALLBACK_ERROR_CODE = "json.format.invalid";
    private static final long serialVersionUID = -6003501868758251973L;

    public DittoJsonException(RuntimeException toWrap) {
        super(toWrap instanceof JsonRuntimeException ? ((JsonException)toWrap).getErrorCode() : FALLBACK_ERROR_CODE, HttpStatus.BAD_REQUEST, DittoHeaders.empty(), toWrap.getMessage(), toWrap instanceof JsonRuntimeException ? (String)((JsonException)toWrap).getDescription().orElse(null) : null, toWrap.getCause(), toWrap instanceof JsonRuntimeException ? (URI)((JsonException)toWrap).getHref().orElse(null) : null);
    }

    public DittoJsonException(RuntimeException toWrap, DittoHeaders dittoHeaders) {
        super(toWrap instanceof JsonRuntimeException ? ((JsonRuntimeException)toWrap).getErrorCode() : FALLBACK_ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, toWrap.getMessage(), toWrap instanceof JsonRuntimeException ? (String)((JsonRuntimeException)toWrap).getDescription().orElse(null) : null, toWrap.getCause(), toWrap instanceof JsonRuntimeException ? (URI)((JsonRuntimeException)toWrap).getHref().orElse(null) : null);
    }

    public static <I, T> T wrapJsonRuntimeException(Function<I, T> function, I input) {
        try {
            return function.apply(input);
        }
        catch (IllegalArgumentException | NullPointerException | JsonRuntimeException e) {
            throw new DittoJsonException((RuntimeException)e);
        }
    }

    public static <T> T wrapJsonRuntimeException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException | JsonRuntimeException e) {
            throw new DittoJsonException((RuntimeException)e);
        }
    }

    public static <T, R> R wrapJsonRuntimeException(T argument, DittoHeaders dittoHeaders, BiFunction<T, DittoHeaders, R> function) {
        try {
            return function.apply(argument, dittoHeaders);
        }
        catch (IllegalArgumentException | NullPointerException | JsonRuntimeException e) {
            throw new DittoJsonException((RuntimeException)e, dittoHeaders);
        }
    }
}

