/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.atteo.classindex.IndexSubclasses;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.model.base.headers.WithManifest;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

@IndexSubclasses
public class DittoRuntimeException
extends RuntimeException
implements Jsonifiable.WithPredicate<JsonObject, JsonField>,
WithDittoHeaders<DittoRuntimeException>,
WithManifest {
    private static final long serialVersionUID = -7010323324132561106L;
    private final String errorCode;
    private final HttpStatus httpStatus;
    private final String description;
    private final URI href;
    private final transient DittoHeaders dittoHeaders;

    @Deprecated
    protected DittoRuntimeException(String errorCode, HttpStatusCode statusCode, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        this(errorCode, ConditionChecker.checkNotNull(statusCode, "HTTP status").getAsHttpStatus(), dittoHeaders, message, description, cause, href);
    }

    protected DittoRuntimeException(String errorCode, HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(message, cause);
        this.errorCode = ConditionChecker.checkNotNull(errorCode, "error code");
        this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "Ditto headers");
        this.description = description;
        this.href = href;
    }

    protected DittoRuntimeExceptionBuilder<? extends DittoRuntimeException> getEmptyBuilder() {
        return new Builder(this.errorCode, this.httpStatus);
    }

    public DittoRuntimeExceptionBuilder<? extends DittoRuntimeException> getBuilder() {
        return this.getEmptyBuilder().dittoHeaders(this.dittoHeaders).message(this.getMessage()).cause(this.getCause()).description(this.description).href(this.href);
    }

    public static DittoRuntimeException asDittoRuntimeException(Throwable throwable, Function<Throwable, DittoRuntimeException> alternativeExceptionBuilder) {
        Throwable cause = DittoRuntimeException.getRootCause(throwable);
        if (cause instanceof DittoRuntimeException) {
            return (DittoRuntimeException)cause;
        }
        return alternativeExceptionBuilder.apply(cause);
    }

    private static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        if ((throwable instanceof CompletionException || throwable instanceof ExecutionException) && null != (cause = throwable.getCause())) {
            return DittoRuntimeException.getRootCause(cause);
        }
        return throwable;
    }

    @Deprecated
    public static Builder newBuilder(String errorCode, HttpStatusCode statusCode) {
        return new Builder(errorCode, statusCode.getAsHttpStatus());
    }

    public static Builder newBuilder(String errorCode, HttpStatus httpStatus) {
        return new Builder(errorCode, httpStatus);
    }

    public static DittoRuntimeExceptionBuilder<? extends DittoRuntimeException> newBuilder(DittoRuntimeException dittoRuntimeException) {
        ConditionChecker.checkNotNull(dittoRuntimeException, "dittoRuntimeException to be copied");
        return dittoRuntimeException.getBuilder().dittoHeaders(dittoRuntimeException.dittoHeaders).message(dittoRuntimeException.getMessage()).description(dittoRuntimeException.description).cause(dittoRuntimeException.getCause()).href(dittoRuntimeException.href);
    }

    @Deprecated
    protected static Optional<URI> readHRef(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        return jsonObject.getValue(JsonFields.HREF).map(URI::create);
    }

    @Deprecated
    protected static String readMessage(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        return (String)jsonObject.getValueOrThrow(JsonFields.MESSAGE);
    }

    @Deprecated
    protected static Optional<String> readDescription(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        return jsonObject.getValue(JsonFields.DESCRIPTION);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Deprecated
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.forInt(this.httpStatus.getCode()).orElseThrow(() -> {
            String msgPattern = "Found no HttpStatusCode for int <{0}>!";
            return new IllegalStateException(MessageFormat.format("Found no HttpStatusCode for int <{0}>!", this.httpStatus.getCode()));
        });
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.dittoHeaders;
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return DittoRuntimeException.newBuilder(this).dittoHeaders(dittoHeaders).build();
    }

    @Override
    public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.dittoHeaders.getSchemaVersion().orElse(this.getLatestSchemaVersion());
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<URI> getHref() {
        return Optional.ofNullable(this.href);
    }

    @Override
    public String getManifest() {
        return this.getErrorCode();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DittoRuntimeException that = (DittoRuntimeException)o;
        return Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.httpStatus, that.httpStatus) && Objects.equals(this.description, that.description) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.href, that.href);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.httpStatus, this.description, this.getMessage(), this.href);
    }

    @Override
    public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    @Override
    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        Predicate<JsonField> nonNullAndCustomDefined = predicate.and(JsonField.isValueNonNull());
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(JsonFields.STATUS, (Object)this.httpStatus.getCode(), nonNullAndCustomDefined).set(JsonFields.ERROR_CODE, (Object)this.errorCode, nonNullAndCustomDefined).set(JsonFields.MESSAGE, (Object)this.getMessage(), nonNullAndCustomDefined).set(JsonFields.DESCRIPTION, (Object)this.description, nonNullAndCustomDefined).set(JsonFields.HREF, (Object)(this.href != null ? this.href.toString() : null), nonNullAndCustomDefined);
        this.appendToJson(jsonObjectBuilder, nonNullAndCustomDefined);
        return jsonObjectBuilder.build();
    }

    public static <T extends DittoRuntimeException> T fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders, DittoRuntimeExceptionBuilder<T> builder) {
        ConditionChecker.checkNotNull(builder, "builder");
        DittoRuntimeException.readDescription(jsonObject).ifPresent(builder::description);
        DittoRuntimeException.readHRef(jsonObject).ifPresent(builder::href);
        return builder.dittoHeaders(dittoHeaders).message(DittoRuntimeException.readMessage(jsonObject)).build();
    }

    public static <T extends DittoRuntimeException> T fromMessage(@Nullable String message, DittoHeaders dittoHeaders, DittoRuntimeExceptionBuilder<T> builder) {
        ConditionChecker.checkNotNull(builder, "builder");
        return builder.dittoHeaders(dittoHeaders).message(message).build();
    }

    protected void appendToJson(JsonObjectBuilder jsonObjectBuilder, Predicate<JsonField> predicate) {
    }

    protected <T extends DittoRuntimeException> DittoRuntimeExceptionBuilder<T> toBuilder(DittoRuntimeExceptionBuilder<T> builder) {
        builder.message(this.getMessage());
        builder.dittoHeaders(this.getDittoHeaders());
        builder.cause(this.getCause());
        this.getHref().ifPresent(builder::href);
        this.getDescription().ifPresent(builder::description);
        return builder;
    }

    public static Optional<DittoRuntimeException> fromUnknownErrorJson(JsonObject jsonObject, DittoHeaders headers) {
        Object result;
        Optional errorCodeOptional = jsonObject.getValue(JsonFields.ERROR_CODE);
        if (errorCodeOptional.isPresent()) {
            Optional<HttpStatus> httpStatusOptional = DittoRuntimeException.getHttpStatus(jsonObject);
            if (httpStatusOptional.isPresent()) {
                Builder builder = new Builder((String)errorCodeOptional.get(), httpStatusOptional.get());
                builder.dittoHeaders(headers);
                jsonObject.getValue(JsonFields.MESSAGE).ifPresent(builder::message);
                jsonObject.getValue(JsonFields.DESCRIPTION).ifPresent(builder::description);
                DittoRuntimeException.getHref(jsonObject).ifPresent(builder::href);
                result = builder.build();
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return Optional.ofNullable(result);
    }

    private static Optional<HttpStatus> getHttpStatus(JsonObject jsonObject) {
        return jsonObject.getValue(JsonFields.STATUS).flatMap(HttpStatus::tryGetInstance);
    }

    private static Optional<URI> getHref(JsonObject jsonObject) {
        Function<String, URI> uriForStringOrNull = uriString -> {
            try {
                return new URI((String)uriString);
            }
            catch (URISyntaxException e) {
                return null;
            }
        };
        return jsonObject.getValue(JsonFields.HREF).map(uriForStringOrNull);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [message='" + this.getMessage() + '\'' + ", errorCode=" + this.errorCode + ", httpStatus=" + this.httpStatus + ", description='" + this.description + '\'' + ", href=" + this.href + ", dittoHeaders=" + this.dittoHeaders + ']';
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> STATUS = JsonFactory.newIntFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ERROR_CODE = JsonFactory.newStringFieldDefinition((CharSequence)"error", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> MESSAGE = JsonFactory.newStringFieldDefinition((CharSequence)"message", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> DESCRIPTION = JsonFactory.newStringFieldDefinition((CharSequence)"description", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> HREF = JsonFactory.newStringFieldDefinition((CharSequence)"href", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DittoRuntimeException> {
        private final String errorCode;
        private final HttpStatus httpStatus;

        private Builder(String theErrorCode, HttpStatus httpStatus) {
            ConditionChecker.checkNotNull(theErrorCode, "exception error code");
            this.errorCode = ConditionChecker.checkNotEmpty(theErrorCode, "exception error code");
            this.httpStatus = ConditionChecker.checkNotNull(httpStatus, "httpStatus");
        }

        @Override
        protected DittoRuntimeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DittoRuntimeException(this.errorCode, this.httpStatus, dittoHeaders, message, description, cause, href);
        }
    }
}

