/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;

@NotThreadSafe
public abstract class DittoRuntimeExceptionBuilder<T extends DittoRuntimeException> {
    private DittoHeaders dittoHeaders = DittoHeaders.empty();
    private String message = null;
    private String description = null;
    private Throwable cause = null;
    private URI href = null;

    protected DittoRuntimeExceptionBuilder() {
    }

    private static void checkSupplier(Supplier<?> supplier) {
        ConditionChecker.checkNotNull(supplier, "supplier");
    }

    public DittoRuntimeExceptionBuilder<T> dittoHeaders(DittoHeaders dittoHeaders) {
        this.dittoHeaders = ConditionChecker.checkNotNull(dittoHeaders, "Ditto Headers");
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> message(@Nullable String message) {
        this.message = message;
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> message(Supplier<String> messageSupplier) {
        DittoRuntimeExceptionBuilder.checkSupplier(messageSupplier);
        return this.message(messageSupplier.get());
    }

    public DittoRuntimeExceptionBuilder<T> description(@Nullable String description) {
        this.description = description;
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> description(Supplier<String> descriptionSupplier) {
        DittoRuntimeExceptionBuilder.checkSupplier(descriptionSupplier);
        return this.description(descriptionSupplier.get());
    }

    public DittoRuntimeExceptionBuilder<T> cause(@Nullable Throwable cause) {
        this.cause = cause;
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> cause(Supplier<Throwable> causeSupplier) {
        DittoRuntimeExceptionBuilder.checkSupplier(causeSupplier);
        return this.cause(causeSupplier.get());
    }

    public DittoRuntimeExceptionBuilder<T> href(@Nullable String href) {
        try {
            URI uriHref = href == null ? null : new URI(href);
            this.href(uriHref);
        }
        catch (URISyntaxException e) {
            this.href((URI)null);
        }
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> href(@Nullable URI href) {
        this.href = href;
        return this;
    }

    public DittoRuntimeExceptionBuilder<T> href(Supplier<URI> hrefSupplier) {
        DittoRuntimeExceptionBuilder.checkSupplier(hrefSupplier);
        return this.href(hrefSupplier.get());
    }

    public T build() {
        return this.doBuild(this.dittoHeaders, this.message, this.description, this.cause, this.href);
    }

    protected abstract T doBuild(DittoHeaders var1, @Nullable String var2, @Nullable String var3, @Nullable Throwable var4, @Nullable URI var5);

    @Deprecated
    public DittoRuntimeExceptionBuilder<T> loadJson(JsonObject jsonObject) {
        jsonObject.getValue(DittoRuntimeException.JsonFields.MESSAGE).ifPresent(this::message);
        jsonObject.getValue(DittoRuntimeException.JsonFields.DESCRIPTION).ifPresent(this::description);
        jsonObject.getValue(DittoRuntimeException.JsonFields.HREF).map(URI::create).ifPresent(this::href);
        return this;
    }
}

