/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="rql.expression.invalid")
public final class InvalidRqlExpressionException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "rql.expression.invalid";
    static final String DEFAULT_DESCRIPTION = "Ensure that all opening parentheses have also closing ones and that the RQL expression is valid.";
    static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;
    private static final long serialVersionUID = 8900314242209005665L;

    private InvalidRqlExpressionException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HTTP_STATUS, dittoHeaders, message, description, cause, href);
    }

    @Override
    protected DittoRuntimeExceptionBuilder<? extends DittoRuntimeException> getEmptyBuilder() {
        return new Builder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static InvalidRqlExpressionException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static InvalidRqlExpressionException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<InvalidRqlExpressionException> {
        private Builder() {
            this.description(InvalidRqlExpressionException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected InvalidRqlExpressionException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new InvalidRqlExpressionException(dittoHeaders, message, description, cause, href);
        }
    }
}

