/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="signal.enrichment.failed")
@Immutable
public final class SignalEnrichmentFailedException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "signal.enrichment.failed";
    private static final HttpStatus DEFAULT_HTTP_STATUS = HttpStatus.INTERNAL_SERVER_ERROR;
    private static final String DEFAULT_MESSAGE = "Signal enrichment failed.";
    private static final String DESCRIPTION_TEMPLATE = "Cause: {0} {1} {2}";
    private static final String DEFAULT_DESCRIPTION = "The cause is unknown. Please try again later.";
    private static final long serialVersionUID = -9012995799489161220L;

    private SignalEnrichmentFailedException(HttpStatus httpStatus, DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, httpStatus, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static SignalEnrichmentFailedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, SignalEnrichmentFailedException.newBuilder().status(jsonObject.getValue(DittoRuntimeException.JsonFields.STATUS).flatMap(HttpStatus::tryGetInstance).orElse(SignalEnrichmentFailedException.DEFAULT_HTTP_STATUS)));
    }

    public static SignalEnrichmentFailedException dueTo(DittoRuntimeException cause) {
        return (SignalEnrichmentFailedException)SignalEnrichmentFailedException.newBuilder().dueTo(cause).dittoHeaders(cause.getDittoHeaders()).build();
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    static /* synthetic */ HttpStatus access$200() {
        return DEFAULT_HTTP_STATUS;
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<SignalEnrichmentFailedException> {
        private HttpStatus httpStatus = SignalEnrichmentFailedException.access$200();

        private Builder() {
            this.message(SignalEnrichmentFailedException.DEFAULT_MESSAGE);
            this.description(SignalEnrichmentFailedException.DEFAULT_DESCRIPTION);
        }

        private Builder status(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Builder dueTo(DittoRuntimeException cause) {
            this.cause(ConditionChecker.checkNotNull(cause, "cause"));
            this.description(MessageFormat.format(SignalEnrichmentFailedException.DESCRIPTION_TEMPLATE, cause.getErrorCode(), cause.getMessage(), cause.getDescription()));
            this.httpStatus = cause.getHttpStatus();
            return this;
        }

        @Override
        protected SignalEnrichmentFailedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new SignalEnrichmentFailedException(this.httpStatus, dittoHeaders, message, description, cause, href);
        }
    }
}

