/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="timeout.invalid")
@Immutable
public final class TimeoutInvalidException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "timeout.invalid";
    private static final String DEFAULT_MESSAGE = "The timeout <{0}{2}> is not inside its allowed bounds <0{2} - {1}{2}>";
    private static final String DEFAULT_DESCRIPTION = "Please choose a valid timeout.";
    private static final long serialVersionUID = -3108409113724423689L;

    private TimeoutInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(Duration timeout, Duration maxTimeout) {
        return (Builder)new Builder().message(MessageFormat.format(DEFAULT_MESSAGE, timeout.toMillis(), maxTimeout.toMillis(), "ms")).description(DEFAULT_DESCRIPTION);
    }

    public static Builder newBuilder(String message) {
        return (Builder)new Builder().message(message).description(DEFAULT_DESCRIPTION);
    }

    public static TimeoutInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<TimeoutInvalidException> {
        public Builder() {
            this.description(TimeoutInvalidException.DEFAULT_DESCRIPTION);
        }

        @Override
        protected TimeoutInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new TimeoutInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

