/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="too.many.requests")
public final class TooManyRequestsException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "too.many.requests";
    static final String RETRY_AFTER = "retry-after";
    private static final HttpStatus STATUS_CODE = HttpStatus.TOO_MANY_REQUESTS;
    private static final String MESSAGE = "You made too many requests.";
    private static final String DESCRIPTION = "Try again soon.";

    private TooManyRequestsException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, STATUS_CODE, dittoHeaders, message, description, cause, href);
    }

    protected DittoRuntimeExceptionBuilder<TooManyRequestsException> getEmptyBuilder() {
        return new Builder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TooManyRequestsException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromMessage(message, dittoHeaders, new Builder());
    }

    public static TooManyRequestsException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<TooManyRequestsException> {
        @Nullable
        private Duration retryAfter;

        private Builder() {
            this.message(TooManyRequestsException.MESSAGE);
            this.description(TooManyRequestsException.DESCRIPTION);
        }

        public Builder retryAfter(Duration duration) {
            this.retryAfter = duration;
            return this;
        }

        @Override
        protected TooManyRequestsException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            DittoHeaders headersWithRetryAfter = this.retryAfter == null ? dittoHeaders : dittoHeaders.toBuilder().putHeader(TooManyRequestsException.RETRY_AFTER, String.valueOf(this.retryAfter.getSeconds())).build();
            return new TooManyRequestsException(headersWithRetryAfter, message, description, cause, href);
        }
    }
}

