/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;

@JsonParsableException(errorCode="mediatype.unsupported")
@Immutable
public final class UnsupportedMediaTypeException
extends DittoRuntimeException {
    public static final String ERROR_CODE = "mediatype.unsupported";
    private static final String DEFAULT_MESSAGE = "The Media-Type is not supported.";
    private static final String MESSAGE_PATTERN = "The Media-Type <{0}> is not supported for this resource.";
    private static final String MESSAGE_PATTERN_EMPTY_CONTENT_TYPE = "The Content-Type header was empty or not present. Please set Content-Type header to \"application/merge-patch+json\" for this resource";
    private static final String DESCRIPTION_ALLOWED_TYPES_PATTERN = "Allowed Media-Types are: <{0}>.";
    private static final String DESCRIPTION_ALLOWED_TYPE_PATTERN = "Allowed Media-Type is: <{0}>.";
    static final String RFC_7396 = "https://tools.ietf.org/html/rfc7396";
    private static final HttpStatus STATUS_CODE = HttpStatus.UNSUPPORTED_MEDIA_TYPE;

    private UnsupportedMediaTypeException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, STATUS_CODE, dittoHeaders, message, description, cause, href);
    }

    public static DittoRuntimeExceptionBuilder<UnsupportedMediaTypeException> withDetailedInformationBuilder(String callersMediaType, Set<String> mediaTypeSupportedByCalledResource) {
        String msgPattern = MessageFormat.format(MESSAGE_PATTERN, callersMediaType);
        String descriptionPattern = MessageFormat.format(DESCRIPTION_ALLOWED_TYPES_PATTERN, mediaTypeSupportedByCalledResource);
        return new Builder().message(msgPattern).description(descriptionPattern);
    }

    public static DittoRuntimeExceptionBuilder<UnsupportedMediaTypeException> builderForMergePatchJsonMediaType(String callersMediaType, String mediaTypeSupportedByCalledResource) {
        String msgPattern = MessageFormat.format(MESSAGE_PATTERN, callersMediaType);
        String descriptionPattern = MessageFormat.format(DESCRIPTION_ALLOWED_TYPE_PATTERN, mediaTypeSupportedByCalledResource);
        URI rfcURI = URI.create(RFC_7396);
        return new Builder().message(msgPattern).description(descriptionPattern).href(rfcURI);
    }

    public static DittoRuntimeExceptionBuilder<UnsupportedMediaTypeException> builderForEmptyContentTypeHeader(String mediaTypeSupportedByCalledResource) {
        String descriptionPattern = MessageFormat.format(DESCRIPTION_ALLOWED_TYPE_PATTERN, mediaTypeSupportedByCalledResource);
        URI rfcURI = URI.create(RFC_7396);
        return new Builder().message(MESSAGE_PATTERN_EMPTY_CONTENT_TYPE).description(descriptionPattern).href(rfcURI);
    }

    public static UnsupportedMediaTypeException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return DittoRuntimeException.fromJson(jsonObject, dittoHeaders, new Builder());
    }

    @Override
    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<UnsupportedMediaTypeException> {
        private Builder() {
            this.message(UnsupportedMediaTypeException.DEFAULT_MESSAGE);
        }

        @Override
        protected UnsupportedMediaTypeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new UnsupportedMediaTypeException(dittoHeaders, message, description, cause, href);
        }
    }
}

