/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.DittoDuration;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.DittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.Header;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.contenttype.ContentType;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTag;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@Immutable
public abstract class AbstractDittoHeaders
extends AbstractMap<String, String>
implements DittoHeaders {
    private static final String ISSUER_DIVIDER = ":";
    final Map<String, Header> headers;

    protected AbstractDittoHeaders(Map<String, String> headers) {
        ConditionChecker.checkNotNull(headers, "headers");
        if (headers instanceof AbstractDittoHeaders) {
            this.headers = ((AbstractDittoHeaders)headers).headers;
        } else {
            Map<String, String> headersWithOnlyPrefixedSubjects = AbstractDittoHeaders.keepAuthContextSubjectsWithIssuer(headers, (key, value) -> value);
            this.headers = AbstractDittoHeaders.indexByLowerCase(headersWithOnlyPrefixedSubjects);
        }
    }

    protected AbstractDittoHeaders(Map<String, Header> headers, boolean flag) {
        ConditionChecker.checkNotNull(headers, "headers");
        LinkedHashMap candidate = AbstractDittoHeaders.keepAuthContextSubjectsWithIssuer(headers, Header::of);
        this.headers = candidate != headers ? candidate : new LinkedHashMap(candidate);
    }

    @Override
    public Map<String, String> asCaseSensitiveMap() {
        LinkedHashMap<String, String> caseSensitiveMap = new LinkedHashMap<String, String>();
        for (Header header : this.headers.values()) {
            caseSensitiveMap.put(header.getKey(), header.getValue());
        }
        return caseSensitiveMap;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof CharSequence)) {
            return false;
        }
        String valueString = value.toString();
        return this.headers.values().stream().map(Header::getValue).anyMatch(valueString::equals);
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.headers.containsKey(key.toString().toLowerCase());
    }

    @Override
    @Nullable
    public String get(Object key) {
        if (key instanceof String) {
            return Optional.ofNullable(this.headers.get(key.toString().toLowerCase())).map(Header::getValue).orElse(null);
        }
        return null;
    }

    private static <T extends CharSequence> Map<String, T> keepAuthContextSubjectsWithIssuer(Map<String, T> headers, BiFunction<String, String, T> fromString) {
        if (headers.containsKey(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey())) {
            LinkedHashMap<String, T> newHeaders = new LinkedHashMap<String, T>(headers);
            AuthorizationContext authContext = AuthorizationModelFactory.newAuthContext(AbstractDittoHeaders.getAuthorizationContextAsJson(headers));
            AuthorizationContext authContextWithoutDups = AbstractDittoHeaders.keepAuthContextSubjectsWithIssuer(authContext);
            newHeaders.put(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey(), (CharSequence)fromString.apply(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey(), authContextWithoutDups.toJsonString()));
            return newHeaders;
        }
        return headers;
    }

    private static JsonObject getAuthorizationContextAsJson(Map<String, ? extends CharSequence> headers) {
        CharSequence jsonObjectString = headers.get(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey());
        JsonObject result = null != jsonObjectString ? JsonObject.of((String)jsonObjectString.toString()) : JsonObject.empty();
        return result;
    }

    protected static AuthorizationContext keepAuthContextSubjectsWithIssuer(AuthorizationContext authContext) {
        Set subjectsWithoutIssuer = authContext.getAuthorizationSubjects().stream().flatMap(authorizationSubject -> {
            String authorizationSubjectId = authorizationSubject.getId();
            String[] issuers = authorizationSubjectId.split(ISSUER_DIVIDER, 2);
            if (2 == issuers.length) {
                return Stream.of(issuers[1]);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        List<AuthorizationSubject> subjectsWithIssuer = authContext.stream().filter(subject -> !subjectsWithoutIssuer.contains(subject.getId())).collect(Collectors.toList());
        return AuthorizationModelFactory.newAuthContext(authContext.getType(), subjectsWithIssuer);
    }

    @Override
    public Optional<String> getCorrelationId() {
        return this.getStringForDefinition(DittoHeaderDefinition.CORRELATION_ID);
    }

    protected Optional<String> getStringForDefinition(HeaderDefinition definition) {
        return Optional.ofNullable(this.get(definition.getKey()));
    }

    @Override
    public Optional<String> getContentType() {
        return this.getStringForDefinition(DittoHeaderDefinition.CONTENT_TYPE);
    }

    @Override
    public Optional<ContentType> getDittoContentType() {
        return this.getContentType().map(ContentType::of);
    }

    @Override
    public Optional<JsonSchemaVersion> getSchemaVersion() {
        return this.getStringForDefinition(DittoHeaderDefinition.SCHEMA_VERSION).map(Integer::valueOf).flatMap(JsonSchemaVersion::forInt);
    }

    @Override
    @Deprecated
    public List<String> getAuthorizationSubjects() {
        return this.getAuthorizationContext().getAuthorizationSubjectIds();
    }

    @Override
    public AuthorizationContext getAuthorizationContext() {
        return AbstractDittoHeaders.duplicateSubjectsByStrippingIssuerPrefix(AuthorizationModelFactory.newAuthContext(AbstractDittoHeaders.getAuthorizationContextAsJson(this.headers)));
    }

    private static AuthorizationContext duplicateSubjectsByStrippingIssuerPrefix(AuthorizationContext authContextWithPrefixedSubjects) {
        List<AuthorizationSubject> prefixedSubjects = authContextWithPrefixedSubjects.getAuthorizationSubjects();
        LinkedHashSet<AuthorizationSubject> mergedSubjects = new LinkedHashSet<AuthorizationSubject>(prefixedSubjects);
        prefixedSubjects.stream().map(AbstractDittoHeaders::getSubjectWithoutIssuer).forEach(mergedSubjects::add);
        return AuthorizationModelFactory.newAuthContext(authContextWithPrefixedSubjects.getType(), mergedSubjects);
    }

    private static AuthorizationSubject getSubjectWithoutIssuer(AuthorizationSubject authorizationSubject) {
        String authorizationSubjectId = authorizationSubject.getId();
        String[] splitInIssuerAndSubject = authorizationSubjectId.split(ISSUER_DIVIDER, 2);
        if (2 == splitInIssuerAndSubject.length) {
            return AuthorizationSubject.newInstance(splitInIssuerAndSubject[1]);
        }
        return authorizationSubject;
    }

    @Override
    public Set<String> getReadSubjects() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.READ_SUBJECTS);
        return jsonValueArray.stream().map(JsonValue::asString).collect(Collectors.toSet());
    }

    protected JsonArray getJsonArrayForDefinition(HeaderDefinition definition) {
        Header jsonArrayHeader = this.headers.get(definition.getKey());
        JsonArray result = null != jsonArrayHeader ? JsonArray.of((String)jsonArrayHeader.getValue()) : JsonArray.empty();
        return result;
    }

    @Override
    public Set<AuthorizationSubject> getReadGrantedSubjects() {
        return this.getAuthorizationSubjectSet(DittoHeaderDefinition.READ_SUBJECTS);
    }

    private Set<AuthorizationSubject> getAuthorizationSubjectSet(HeaderDefinition definition) {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(definition);
        return jsonValueArray.stream().map(JsonValue::asString).map(AuthorizationSubject::newInstance).collect(Collectors.toSet());
    }

    @Override
    public Set<AuthorizationSubject> getReadRevokedSubjects() {
        return this.getAuthorizationSubjectSet(DittoHeaderDefinition.READ_REVOKED_SUBJECTS);
    }

    @Override
    public Optional<String> getChannel() {
        return this.getStringForDefinition(DittoHeaderDefinition.CHANNEL);
    }

    @Override
    public boolean isResponseRequired() {
        return !this.isExpectedBoolean(DittoHeaderDefinition.RESPONSE_REQUIRED, Boolean.FALSE);
    }

    protected boolean isExpectedBoolean(HeaderDefinition headerDefinition, Boolean expected) {
        String expectedString = expected.toString();
        return Optional.ofNullable(this.headers.get(headerDefinition.getKey())).map(Header::getValue).filter(expectedString::equalsIgnoreCase).isPresent();
    }

    protected abstract Optional<HeaderDefinition> getSpecificDefinitionByKey(CharSequence var1);

    @Deprecated
    protected Optional<Boolean> getBooleanForDefinition(HeaderDefinition definition) {
        return this.getStringForDefinition(definition).map(JsonFactory::readFrom).filter(JsonValue::isBoolean).map(JsonValue::asBoolean);
    }

    @Override
    public boolean isDryRun() {
        return this.isExpectedBoolean(DittoHeaderDefinition.DRY_RUN, Boolean.TRUE);
    }

    @Override
    public Optional<String> getOrigin() {
        return this.getStringForDefinition(DittoHeaderDefinition.ORIGIN);
    }

    @Override
    public Optional<EntityTag> getETag() {
        return this.getStringForDefinition(DittoHeaderDefinition.ETAG).map(EntityTag::fromString);
    }

    @Override
    public Optional<EntityTagMatchers> getIfMatch() {
        return this.getStringForDefinition(DittoHeaderDefinition.IF_MATCH).map(EntityTagMatchers::fromCommaSeparatedString);
    }

    @Override
    public Optional<EntityTagMatchers> getIfNoneMatch() {
        return this.getStringForDefinition(DittoHeaderDefinition.IF_NONE_MATCH).map(EntityTagMatchers::fromCommaSeparatedString);
    }

    @Override
    public Optional<String> getInboundPayloadMapper() {
        return this.getStringForDefinition(DittoHeaderDefinition.INBOUND_PAYLOAD_MAPPER);
    }

    @Override
    public Optional<Integer> getReplyTarget() {
        return this.getStringForDefinition(DittoHeaderDefinition.REPLY_TARGET).map(Integer::valueOf);
    }

    @Override
    public Collection<ResponseType> getExpectedResponseTypes() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.EXPECTED_RESPONSE_TYPES);
        return jsonValueArray.stream().map(JsonValue::asString).map(ResponseType::fromName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public Set<AcknowledgementRequest> getAcknowledgementRequests() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.REQUESTED_ACKS);
        return jsonValueArray.stream().map(JsonValue::asString).map(AcknowledgementRequest::parseAcknowledgementRequest).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Optional<Duration> getTimeout() {
        return this.getStringForDefinition(DittoHeaderDefinition.TIMEOUT).map(DittoDuration::parseDuration).map(DittoDuration::getDuration);
    }

    @Override
    public MetadataHeaders getMetadataHeadersToPut() {
        String metadataHeaderValue = this.getOrDefault(DittoHeaderDefinition.PUT_METADATA.getKey(), "");
        return MetadataHeaders.parseMetadataHeaders(metadataHeaderValue);
    }

    @Override
    public boolean isAllowPolicyLockout() {
        return this.isExpectedBoolean(DittoHeaderDefinition.ALLOW_POLICY_LOCKOUT, Boolean.TRUE);
    }

    @Override
    public Set<String> getJournalTags() {
        JsonArray jsonValueArray = this.getJsonArrayForDefinition(DittoHeaderDefinition.EVENT_JOURNAL_TAGS);
        return jsonValueArray.stream().map(JsonValue::asString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonObject.newBuilder();
        this.headers.forEach((key, header) -> {
            Class<?> type = this.getSerializationTypeForKey((CharSequence)key);
            JsonValue jsonValue = CharSequence.class.isAssignableFrom(type) ? JsonValue.of((String)header.getValue()) : JsonFactory.readFrom((String)header.getValue());
            jsonObjectBuilder.set((CharSequence)header.getKey(), jsonValue);
        });
        return jsonObjectBuilder.build();
    }

    private Class<?> getSerializationTypeForKey(CharSequence key) {
        return this.getSpecificDefinitionByKey(key).map(HeaderDefinition::getSerializationType).orElseGet(() -> DittoHeaderDefinition.forKey(key).map(HeaderDefinition::getSerializationType).orElse(String.class));
    }

    @Override
    public String put(String key, String value) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    private static UnsupportedOperationException newUnsupportedOperationException() {
        return new UnsupportedOperationException("Ditto Headers are immutable!");
    }

    @Override
    public String remove(Object key) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ? extends String> m) {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw AbstractDittoHeaders.newUnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> entrySet() {
        Set linkedHashSet = this.headers.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), ((Header)entry.getValue()).getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(linkedHashSet);
    }

    @Override
    public boolean isEntriesSizeGreaterThan(long size) {
        ConditionChecker.checkArgument(size, s -> 0L <= size, () -> MessageFormat.format("The size to compare to must not be negative but it was <{0}>!", size));
        long quota = size;
        for (Header header : this.headers.values()) {
            if (0L <= (quota -= (long)AbstractDittoHeaders.getHeaderLength(header))) continue;
            return true;
        }
        return false;
    }

    @Override
    public DittoHeaders truncate(long maxSizeBytes) {
        ConditionChecker.checkArgument(maxSizeBytes, s -> 0L <= maxSizeBytes, () -> MessageFormat.format("The max size bytes must not be negative but it was <{0}>!", maxSizeBytes));
        DittoHeadersBuilder builder = DittoHeaders.newBuilder();
        long quota = maxSizeBytes;
        for (Header entry : this.getSortedHeadersByLength()) {
            if ((quota -= (long)AbstractDittoHeaders.getHeaderLength(entry)) < 0L) break;
            builder.putHeader(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Nonnull
    private List<Header> getSortedHeadersByLength() {
        return this.headers.values().stream().sorted(Comparator.comparingInt(AbstractDittoHeaders::getHeaderLength)).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return this.headers.toString();
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractDittoHeaders) {
            AbstractDittoHeaders that = (AbstractDittoHeaders)other;
            return Objects.equals(this.headers, that.headers);
        }
        if (other instanceof Map) {
            return this.headers.equals(other);
        }
        return false;
    }

    private static int getHeaderLength(Header header) {
        return header.getKey().length() + header.getValue().length();
    }

    private static Map<String, Header> indexByLowerCase(Map<String, String> map) {
        LinkedHashMap headers = new LinkedHashMap();
        map.forEach((key, value) -> headers.put(key.toLowerCase(), Header.of(key, value)));
        return Collections.unmodifiableMap(headers);
    }
}

