/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueContainer;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.DittoDuration;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractDittoHeaders;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.DittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.Header;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.ImmutableDittoHeaders;
import org.eclipse.ditto.model.base.headers.contenttype.ContentType;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTag;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeader;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaderKey;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@NotThreadSafe
public abstract class AbstractDittoHeadersBuilder<S extends AbstractDittoHeadersBuilder<S, R>, R extends DittoHeaders>
implements DittoHeadersBuilder<S, R> {
    private static final Map<String, HeaderDefinition> BUILT_IN_DEFINITIONS;
    protected final S myself;
    private final Map<String, Header> headers;
    private MetadataHeaders metadataHeaders;
    private final Map<String, HeaderDefinition> definitions;

    protected AbstractDittoHeadersBuilder(Map<String, String> initialHeaders, Collection<? extends HeaderDefinition> definitions, Class<?> selfType) {
        ConditionChecker.checkNotNull(initialHeaders, "initial headers");
        ConditionChecker.checkNotNull(definitions, "header definitions");
        this.validateValueTypes(initialHeaders, definitions);
        this.myself = (AbstractDittoHeadersBuilder)selfType.cast(this);
        this.headers = AbstractDittoHeadersBuilder.preserveCaseSensitivity(initialHeaders);
        this.metadataHeaders = MetadataHeaders.newInstance();
        this.metadataHeaders.addAll(AbstractDittoHeadersBuilder.extractMetadataHeaders(this.headers));
        this.definitions = AbstractDittoHeadersBuilder.getHeaderDefinitionsAsMap(definitions);
    }

    private static MetadataHeaders extractMetadataHeaders(Map<String, Header> headers) {
        CharSequence metadataHeadersCharSequence = headers.remove(DittoHeaderDefinition.PUT_METADATA.getKey());
        MetadataHeaders result = null != metadataHeadersCharSequence ? MetadataHeaders.parseMetadataHeaders(metadataHeadersCharSequence) : MetadataHeaders.newInstance();
        return result;
    }

    private static Map<String, HeaderDefinition> getHeaderDefinitionsAsMap(Collection<? extends HeaderDefinition> headerDefinitions) {
        DittoHeaderDefinition[] dittoHeaderDefinitions = DittoHeaderDefinition.values();
        LinkedHashMap<String, HeaderDefinition> result = new LinkedHashMap<String, HeaderDefinition>(headerDefinitions.size() + dittoHeaderDefinitions.length);
        for (HeaderDefinition headerDefinition : headerDefinitions) {
            result.put(headerDefinition.getKey(), headerDefinition);
        }
        result.putAll(BUILT_IN_DEFINITIONS);
        return result;
    }

    protected AbstractDittoHeadersBuilder(R initialHeaders, Collection<? extends HeaderDefinition> definitions, Class<?> selfType) {
        ConditionChecker.checkNotNull(initialHeaders, "initialHeaders");
        ConditionChecker.checkNotNull(definitions, "definitions");
        this.myself = (AbstractDittoHeadersBuilder)selfType.cast(this);
        this.headers = AbstractDittoHeadersBuilder.preserveCaseSensitivity(initialHeaders);
        this.metadataHeaders = MetadataHeaders.newInstance();
        this.metadataHeaders.addAll(AbstractDittoHeadersBuilder.extractMetadataHeaders(this.headers));
        this.definitions = AbstractDittoHeadersBuilder.getHeaderDefinitionsAsMap(definitions);
    }

    protected void validateValueTypes(Map<String, String> headers, Collection<? extends HeaderDefinition> definitions) {
        for (HeaderDefinition headerDefinition : definitions) {
            String value = headers.get(headerDefinition.getKey());
            if (null == value) continue;
            headerDefinition.validateValue(value);
        }
    }

    protected static Map<String, String> toMap(JsonValueContainer<JsonField> jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "JSON object");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(jsonObject.getSize());
        jsonObject.forEach(jsonField -> {
            JsonValue jsonValue = jsonField.getValue();
            String stringValue = jsonValue.isString() ? jsonValue.asString() : jsonValue.toString();
            result.put(jsonField.getKeyName(), stringValue);
        });
        return result;
    }

    @Override
    public S correlationId(@Nullable CharSequence correlationId) {
        String key = DittoHeaderDefinition.CORRELATION_ID.getKey();
        if (correlationId != null) {
            ConditionChecker.checkNotEmpty(correlationId, "correlationId");
            Header previousCorrelationId = this.headers.remove(key);
            if (previousCorrelationId != null) {
                this.headers.put(key, Header.of(previousCorrelationId.getKey(), correlationId.toString()));
            } else {
                this.headers.put(key, Header.of(key, correlationId.toString()));
            }
        } else {
            this.headers.remove(key);
        }
        return this.myself;
    }

    protected void putCharSequence(HeaderDefinition definition, @Nullable CharSequence value) {
        if (null != value) {
            ConditionChecker.checkNotEmpty(value, definition.getKey());
            this.headers.remove(definition.getKey());
            this.headers.put(definition.getKey(), Header.of(definition.getKey(), value.toString()));
        } else {
            this.removeHeader(definition.getKey());
        }
    }

    @Override
    public S schemaVersion(@Nullable JsonSchemaVersion schemaVersion) {
        if (null != schemaVersion) {
            this.putCharSequence(DittoHeaderDefinition.SCHEMA_VERSION, schemaVersion.toString());
        } else {
            this.removeHeader(DittoHeaderDefinition.SCHEMA_VERSION.getKey());
        }
        return this.myself;
    }

    @Override
    public S authorizationContext(@Nullable AuthorizationContext authorizationContext) {
        if (null != authorizationContext) {
            this.putJsonValue(DittoHeaderDefinition.AUTHORIZATION_CONTEXT, (JsonValue)authorizationContext.toJson());
        } else {
            this.removeHeader(DittoHeaderDefinition.AUTHORIZATION_CONTEXT.getKey());
        }
        return this.myself;
    }

    @Override
    public S replyTarget(@Nullable Integer replyTarget) {
        if (replyTarget != null) {
            this.putCharSequence(DittoHeaderDefinition.REPLY_TARGET, String.valueOf(replyTarget));
        } else {
            this.removeHeader(DittoHeaderDefinition.REPLY_TARGET.getKey());
        }
        return this.myself;
    }

    @Override
    public S expectedResponseTypes(ResponseType ... responseTypes) {
        ConditionChecker.checkNotNull(responseTypes, "responseTypes");
        List<String> expectedResponseTypes = Arrays.stream(responseTypes).map(ResponseType::getName).collect(Collectors.toList());
        this.putStringCollection(DittoHeaderDefinition.EXPECTED_RESPONSE_TYPES, expectedResponseTypes);
        return this.myself;
    }

    @Override
    public S expectedResponseTypes(Collection<ResponseType> responseTypes) {
        ConditionChecker.checkNotNull(responseTypes, "responseTypes");
        if (!responseTypes.isEmpty()) {
            List<String> expectedResponseTypes = responseTypes.stream().map(ResponseType::getName).collect(Collectors.toList());
            this.putStringCollection(DittoHeaderDefinition.EXPECTED_RESPONSE_TYPES, expectedResponseTypes);
        }
        return this.myself;
    }

    protected void putStringCollection(HeaderDefinition definition, Collection<String> collection) {
        ConditionChecker.checkNotNull(collection, definition.getKey());
        this.putJsonValue(definition, AbstractDittoHeadersBuilder.toJsonValueArray(collection));
    }

    private static JsonValue toJsonValueArray(Collection<String> stringCollection) {
        return (JsonValue)stringCollection.stream().map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray());
    }

    private void putJsonValue(HeaderDefinition definition, JsonValue jsonValue) {
        this.putCharSequence(definition, jsonValue.isString() ? jsonValue.asString() : jsonValue.toString());
    }

    @Override
    @Deprecated
    public S authorizationSubjects(Collection<String> authorizationSubjectIds) {
        this.authorizationContext(AbstractDittoHeadersBuilder.keepSubjectsWithIssuerPrefix(authorizationSubjectIds));
        return this.myself;
    }

    private static AuthorizationContext keepSubjectsWithIssuerPrefix(Collection<String> subjectsWithAndWithoutPrefix) {
        List<AuthorizationSubject> authSubjects = subjectsWithAndWithoutPrefix.stream().map(AuthorizationSubject::newInstance).collect(Collectors.toList());
        AuthorizationContext authorizationContext = AuthorizationContext.newInstance(DittoAuthorizationContextType.UNSPECIFIED, authSubjects);
        return AbstractDittoHeaders.keepAuthContextSubjectsWithIssuer(authorizationContext);
    }

    @Override
    @Deprecated
    public S authorizationSubjects(CharSequence authorizationSubject, CharSequence ... furtherAuthorizationSubjects) {
        ConditionChecker.checkNotNull(authorizationSubject, "Authorization Subject ID");
        ConditionChecker.checkNotNull(furtherAuthorizationSubjects, "further Authorization Subject IDs");
        ArrayList<String> allAuthorizationSubjects = new ArrayList<String>(1 + furtherAuthorizationSubjects.length);
        allAuthorizationSubjects.add(authorizationSubject.toString());
        for (CharSequence furtherAuthorizationSubject : furtherAuthorizationSubjects) {
            ConditionChecker.checkNotNull(furtherAuthorizationSubject, "further Authorization Subject ID");
            allAuthorizationSubjects.add(furtherAuthorizationSubject.toString());
        }
        return (S)this.authorizationSubjects(allAuthorizationSubjects);
    }

    @Override
    public S readSubjects(Collection<String> readSubjects) {
        this.putStringCollection(DittoHeaderDefinition.READ_SUBJECTS, readSubjects);
        return this.myself;
    }

    @Override
    public S readGrantedSubjects(Collection<AuthorizationSubject> readGrantedSubjects) {
        this.putAuthorizationSubjectCollection(readGrantedSubjects, DittoHeaderDefinition.READ_SUBJECTS);
        return this.myself;
    }

    private void putAuthorizationSubjectCollection(Collection<AuthorizationSubject> authorizationSubjects, HeaderDefinition definition) {
        ConditionChecker.checkNotNull(authorizationSubjects, definition.getKey());
        JsonArray authorizationSubjectIdsJsonArray = (JsonArray)authorizationSubjects.stream().map(AuthorizationSubject::getId).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray());
        this.putJsonValue(definition, (JsonValue)authorizationSubjectIdsJsonArray);
    }

    @Override
    public S readRevokedSubjects(Collection<AuthorizationSubject> readRevokedSubjects) {
        this.putAuthorizationSubjectCollection(readRevokedSubjects, DittoHeaderDefinition.READ_REVOKED_SUBJECTS);
        return this.myself;
    }

    @Override
    public S channel(@Nullable CharSequence channel) {
        this.putCharSequence(DittoHeaderDefinition.CHANNEL, channel);
        return this.myself;
    }

    @Override
    public S responseRequired(boolean responseRequired) {
        this.putBoolean(DittoHeaderDefinition.RESPONSE_REQUIRED, responseRequired);
        return this.myself;
    }

    protected void putBoolean(HeaderDefinition definition, boolean value) {
        this.putJsonValue(definition, JsonFactory.newValue((boolean)value));
    }

    @Override
    public S dryRun(boolean dryRun) {
        this.putBoolean(DittoHeaderDefinition.DRY_RUN, dryRun);
        return this.myself;
    }

    @Override
    public S origin(CharSequence origin) {
        this.putCharSequence(DittoHeaderDefinition.ORIGIN, origin);
        return this.myself;
    }

    @Override
    public S contentType(@Nullable CharSequence contentType) {
        this.putCharSequence(DittoHeaderDefinition.CONTENT_TYPE, contentType);
        return this.myself;
    }

    @Override
    public S contentType(@Nullable ContentType contentType) {
        if (null != contentType) {
            this.putCharSequence(DittoHeaderDefinition.CONTENT_TYPE, contentType.getValue());
        } else {
            this.removeHeader(DittoHeaderDefinition.CONTENT_TYPE.getKey());
        }
        return this.myself;
    }

    @Override
    public S eTag(EntityTag eTag) {
        this.putCharSequence(DittoHeaderDefinition.ETAG, eTag.toString());
        return this.myself;
    }

    @Override
    public S ifMatch(EntityTagMatchers entityTags) {
        this.putCharSequence(DittoHeaderDefinition.IF_MATCH, entityTags.toString());
        return this.myself;
    }

    @Override
    public S ifNoneMatch(EntityTagMatchers entityTags) {
        this.putCharSequence(DittoHeaderDefinition.IF_NONE_MATCH, entityTags.toString());
        return this.myself;
    }

    @Override
    public S inboundPayloadMapper(@Nullable String inboundPayloadMapperId) {
        this.putCharSequence(DittoHeaderDefinition.INBOUND_PAYLOAD_MAPPER, inboundPayloadMapperId);
        return this.myself;
    }

    @Override
    public S acknowledgementRequests(Collection<AcknowledgementRequest> acknowledgementRequests) {
        ConditionChecker.checkNotNull(acknowledgementRequests, "acknowledgementRequests");
        this.putJsonValue(DittoHeaderDefinition.REQUESTED_ACKS, (JsonValue)acknowledgementRequests.stream().map(AcknowledgementRequest::toString).map(JsonValue::of).collect(JsonCollectors.valuesToArray()));
        return this.myself;
    }

    @Override
    public S acknowledgementRequest(AcknowledgementRequest acknowledgementRequest, AcknowledgementRequest ... furtherAcknowledgementRequests) {
        ConditionChecker.checkNotNull(acknowledgementRequest, "acknowledgementRequest");
        ConditionChecker.checkNotNull(furtherAcknowledgementRequests, "furtherAcknowledgementRequests");
        ArrayList<AcknowledgementRequest> ackRequests = new ArrayList<AcknowledgementRequest>(1 + furtherAcknowledgementRequests.length);
        ackRequests.add(acknowledgementRequest);
        Collections.addAll(ackRequests, furtherAcknowledgementRequests);
        return (S)this.acknowledgementRequests(ackRequests);
    }

    @Override
    public S timeout(@Nullable CharSequence timeoutStr) {
        if (null != timeoutStr) {
            return this.timeout(AbstractDittoHeadersBuilder.tryToParseDuration(timeoutStr));
        }
        return this.timeout((DittoDuration)null);
    }

    private static DittoDuration tryToParseDuration(CharSequence duration) {
        try {
            return DittoDuration.parseDuration(duration);
        }
        catch (IllegalArgumentException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(DittoHeaderDefinition.TIMEOUT.getKey(), duration, "duration").build();
        }
    }

    @Override
    public S timeout(@Nullable Duration timeout) {
        if (null != timeout) {
            return this.timeout(DittoDuration.of(timeout));
        }
        return this.timeout((DittoDuration)null);
    }

    private S timeout(@Nullable DittoDuration timeout) {
        DittoHeaderDefinition definition = DittoHeaderDefinition.TIMEOUT;
        if (null != timeout) {
            this.putCharSequence(definition, timeout.toString());
        } else {
            this.removeHeader(definition.getKey());
        }
        return this.myself;
    }

    @Override
    public S putMetadata(MetadataHeaderKey key, JsonValue value) {
        this.metadataHeaders.add(MetadataHeader.of(key, value));
        return this.myself;
    }

    @Override
    public S allowPolicyLockout(boolean allowPolicyLockout) {
        this.putBoolean(DittoHeaderDefinition.ALLOW_POLICY_LOCKOUT, allowPolicyLockout);
        return this.myself;
    }

    @Override
    public S journalTags(Collection<String> journalTags) {
        this.putJsonValue(DittoHeaderDefinition.EVENT_JOURNAL_TAGS, (JsonValue)journalTags.stream().map(JsonValue::of).collect(JsonCollectors.valuesToArray()));
        return this.myself;
    }

    @Override
    public S putHeader(CharSequence key, CharSequence value) {
        AbstractDittoHeadersBuilder.validateKey(key);
        ConditionChecker.checkNotNull(value, "value");
        String keyString = key.toString().toLowerCase();
        this.validateValueType(keyString, value);
        if (AbstractDittoHeadersBuilder.isMetadataKey(keyString)) {
            this.metadataHeaders = MetadataHeaders.parseMetadataHeaders(value);
        } else if (DittoHeaderDefinition.CORRELATION_ID.getKey().equals(keyString)) {
            this.correlationId(value);
        } else {
            this.headers.remove(keyString);
            this.headers.put(keyString, Header.of(key.toString(), value.toString()));
        }
        return this.myself;
    }

    private static void validateKey(CharSequence key) {
        ConditionChecker.argumentNotEmpty(key, "key");
    }

    protected void validateValueType(CharSequence key, CharSequence value) {
        HeaderDefinition headerDefinition = this.definitions.get(key.toString());
        if (null != headerDefinition) {
            headerDefinition.validateValue(value);
        }
    }

    private static boolean isMetadataKey(CharSequence key) {
        return Objects.equals(DittoHeaderDefinition.PUT_METADATA.getKey(), key.toString());
    }

    @Override
    public S putHeaders(Map<String, String> headers) {
        ConditionChecker.checkNotNull(headers, "headers");
        headers.forEach((charSequence, charSequence2) -> this.putHeader((CharSequence)charSequence, (CharSequence)charSequence2));
        return this.myself;
    }

    @Override
    public S removeHeader(CharSequence key) {
        AbstractDittoHeadersBuilder.validateKey(key);
        String keyString = key.toString().toLowerCase();
        this.headers.remove(keyString);
        if (AbstractDittoHeadersBuilder.isMetadataKey(keyString)) {
            this.metadataHeaders.clear();
        }
        return this.myself;
    }

    @Override
    public S removePreconditionHeaders() {
        this.headers.remove(DittoHeaderDefinition.IF_MATCH.getKey());
        this.headers.remove(DittoHeaderDefinition.IF_NONE_MATCH.getKey());
        return this.myself;
    }

    @Override
    public R build() {
        this.putMetadataHeadersToRegularHeaders();
        ImmutableDittoHeaders dittoHeaders = ImmutableDittoHeaders.fromBuilder(this.headers);
        return this.doBuild(dittoHeaders);
    }

    private void putMetadataHeadersToRegularHeaders() {
        if (!this.metadataHeaders.isEmpty()) {
            this.headers.put(DittoHeaderDefinition.PUT_METADATA.getKey(), Header.of(DittoHeaderDefinition.PUT_METADATA.getKey(), this.metadataHeaders.toJsonString()));
        }
    }

    public String toString() {
        this.putMetadataHeadersToRegularHeaders();
        return this.headers.toString();
    }

    protected abstract R doBuild(DittoHeaders var1);

    private static Map<String, Header> preserveCaseSensitivity(Map<String, String> headers) {
        if (headers instanceof AbstractDittoHeaders) {
            return new LinkedHashMap<String, Header>(((AbstractDittoHeaders)headers).headers);
        }
        LinkedHashMap<String, Header> result = new LinkedHashMap<String, Header>();
        headers.forEach((k, v) -> result.put(k.toLowerCase(), Header.of(k, v)));
        return result;
    }

    static {
        DittoHeaderDefinition[] dittoHeaderDefinitions = DittoHeaderDefinition.values();
        LinkedHashMap<String, DittoHeaderDefinition> definitions = new LinkedHashMap<String, DittoHeaderDefinition>(dittoHeaderDefinitions.length);
        for (DittoHeaderDefinition dittoHeaderDefinition : dittoHeaderDefinitions) {
            definitions.put(dittoHeaderDefinition.getKey(), dittoHeaderDefinition);
        }
        BUILT_IN_DEFINITIONS = Collections.unmodifiableMap(definitions);
    }
}

