/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.ValueValidator;

public abstract class AbstractHeaderValueValidator
implements ValueValidator {
    private final Predicate<Class<?>> valueTypePredicate;

    protected AbstractHeaderValueValidator(Predicate<Class<?>> valueTypePredicate) {
        this.valueTypePredicate = ConditionChecker.checkNotNull(valueTypePredicate, "valueTypePredicate");
    }

    @Override
    public void accept(HeaderDefinition definition, CharSequence value) {
        ConditionChecker.checkNotNull(definition, "definition");
        if (this.isThisValidatorResponsible(definition)) {
            AbstractHeaderValueValidator.assertValueNotNull(definition, value);
            this.validateValue(definition, value);
        }
    }

    private boolean isThisValidatorResponsible(HeaderDefinition definition) {
        return this.canValidate(definition.getJavaType());
    }

    @Override
    public boolean canValidate(@Nullable Class<?> valueType) {
        return this.valueTypePredicate.test(valueType);
    }

    private static void assertValueNotNull(HeaderDefinition definition, @Nullable CharSequence value) {
        if (null == value) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, definition.getJavaType().getSimpleName()).build();
        }
    }

    protected abstract void validateValue(HeaderDefinition var1, CharSequence var2);

    @Override
    public ValueValidator andThen(final ValueValidator after) {
        ConditionChecker.checkNotNull(after, "after");
        return new AbstractHeaderValueValidator(valueType -> true){

            @Override
            public void accept(HeaderDefinition definition, CharSequence value) {
                AbstractHeaderValueValidator.this.accept(definition, value);
                after.accept(definition, value);
            }

            @Override
            protected void validateValue(HeaderDefinition definition, CharSequence value) {
            }
        };
    }
}

