/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValueContainer;
import org.eclipse.ditto.model.base.headers.AbstractDittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.ImmutableDittoHeaders;

@NotThreadSafe
final class DefaultDittoHeadersBuilder
extends AbstractDittoHeadersBuilder<DefaultDittoHeadersBuilder, DittoHeaders> {
    private static final DittoHeaders EMPTY_DITTO_HEADERS = ImmutableDittoHeaders.of(Collections.emptyMap());
    private static final EnumSet<DittoHeaderDefinition> DEFINITIONS = EnumSet.allOf(DittoHeaderDefinition.class);

    private DefaultDittoHeadersBuilder(Map<String, String> headers) {
        super(headers, (Collection<? extends HeaderDefinition>)DEFINITIONS, (Class<?>)DefaultDittoHeadersBuilder.class);
    }

    private DefaultDittoHeadersBuilder(DittoHeaders dittoHeaders) {
        super(dittoHeaders, (Collection<? extends HeaderDefinition>)DEFINITIONS, (Class<?>)DefaultDittoHeadersBuilder.class);
    }

    static DefaultDittoHeadersBuilder newInstance() {
        return DefaultDittoHeadersBuilder.of(new HashMap<String, String>());
    }

    static DefaultDittoHeadersBuilder of(Map<String, String> headers) {
        if (headers instanceof DittoHeaders) {
            return new DefaultDittoHeadersBuilder((DittoHeaders)headers);
        }
        return new DefaultDittoHeadersBuilder(headers);
    }

    static DefaultDittoHeadersBuilder of(JsonObject jsonObject) {
        return DefaultDittoHeadersBuilder.of(DefaultDittoHeadersBuilder.toMap((JsonValueContainer<JsonField>)jsonObject));
    }

    static DittoHeaders getEmptyHeaders() {
        return EMPTY_DITTO_HEADERS;
    }

    @Override
    protected DittoHeaders doBuild(DittoHeaders dittoHeaders) {
        return dittoHeaders;
    }
}

