/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.DittoDuration;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class DittoDurationValueValidator
extends AbstractHeaderValueValidator {
    private static final DittoDurationValueValidator INSTANCE = new DittoDurationValueValidator();

    private DittoDurationValueValidator() {
        super(DittoDuration.class::equals);
    }

    static DittoDurationValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            DittoDuration.parseDuration(value);
        }
        catch (IllegalArgumentException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "duration").build();
        }
    }
}

