/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.headers.DefaultDittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeadersBuilder;
import org.eclipse.ditto.model.base.headers.contenttype.ContentType;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTag;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;

public interface DittoHeaders
extends Jsonifiable<JsonObject>,
Map<String, String> {
    public static DittoHeaders empty() {
        return DefaultDittoHeadersBuilder.getEmptyHeaders();
    }

    public static DittoHeaders of(Map<String, String> headers) {
        if (headers instanceof DittoHeaders) {
            return (DittoHeaders)headers;
        }
        return DittoHeaders.newBuilder(headers).build();
    }

    public static DittoHeadersBuilder newBuilder() {
        return DefaultDittoHeadersBuilder.newInstance();
    }

    public static DittoHeadersBuilder newBuilder(Map<String, String> headers) {
        return DefaultDittoHeadersBuilder.of(headers);
    }

    public static DittoHeadersBuilder newBuilder(JsonObject jsonObject) {
        return DefaultDittoHeadersBuilder.of(jsonObject);
    }

    @Deprecated
    public static String readSubjectsToString(Set<String> readSubjects) {
        return String.join((CharSequence)",", readSubjects);
    }

    @Deprecated
    public static Set<String> readSubjectsFromString(String readSubjectsString) {
        return new HashSet<String>(Arrays.asList(readSubjectsString.split(",")));
    }

    default public DittoHeadersBuilder toBuilder() {
        return DefaultDittoHeadersBuilder.of(this);
    }

    public Optional<String> getCorrelationId();

    public Optional<String> getContentType();

    public Optional<ContentType> getDittoContentType();

    public Optional<JsonSchemaVersion> getSchemaVersion();

    @Deprecated
    public List<String> getAuthorizationSubjects();

    public AuthorizationContext getAuthorizationContext();

    @Deprecated
    public Set<String> getReadSubjects();

    public Set<AuthorizationSubject> getReadGrantedSubjects();

    public Set<AuthorizationSubject> getReadRevokedSubjects();

    public Optional<String> getChannel();

    public boolean isResponseRequired();

    public boolean isDryRun();

    public Optional<String> getOrigin();

    public Optional<EntityTag> getETag();

    public Optional<EntityTagMatchers> getIfMatch();

    public Optional<EntityTagMatchers> getIfNoneMatch();

    public Optional<String> getInboundPayloadMapper();

    public Optional<Integer> getReplyTarget();

    public Collection<ResponseType> getExpectedResponseTypes();

    public boolean isEntriesSizeGreaterThan(long var1);

    public DittoHeaders truncate(long var1);

    public Set<AcknowledgementRequest> getAcknowledgementRequests();

    public Optional<Duration> getTimeout();

    public MetadataHeaders getMetadataHeadersToPut();

    public boolean isAllowPolicyLockout();

    public Set<String> getJournalTags();

    public Map<String, String> asCaseSensitiveMap();
}

