/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.contenttype.ContentType;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTag;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatchers;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaderKey;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

@NotThreadSafe
public interface DittoHeadersBuilder<B extends DittoHeadersBuilder<B, R>, R extends DittoHeaders> {
    public B correlationId(@Nullable CharSequence var1);

    default public B randomCorrelationId() {
        return this.correlationId(String.valueOf(UUID.randomUUID()));
    }

    public B schemaVersion(@Nullable JsonSchemaVersion var1);

    public B authorizationContext(@Nullable AuthorizationContext var1);

    @Deprecated
    public B authorizationSubjects(Collection<String> var1);

    @Deprecated
    public B authorizationSubjects(CharSequence var1, CharSequence ... var2);

    @Deprecated
    public B readSubjects(Collection<String> var1);

    public B readGrantedSubjects(Collection<AuthorizationSubject> var1);

    public B readRevokedSubjects(Collection<AuthorizationSubject> var1);

    public B channel(@Nullable CharSequence var1);

    public B responseRequired(boolean var1);

    public B dryRun(boolean var1);

    public B origin(CharSequence var1);

    public B contentType(@Nullable CharSequence var1);

    public B contentType(@Nullable ContentType var1);

    public B eTag(EntityTag var1);

    public B ifMatch(EntityTagMatchers var1);

    public B ifNoneMatch(EntityTagMatchers var1);

    public B inboundPayloadMapper(@Nullable String var1);

    public B replyTarget(@Nullable Integer var1);

    public B expectedResponseTypes(ResponseType ... var1);

    public B expectedResponseTypes(Collection<ResponseType> var1);

    public B acknowledgementRequests(Collection<AcknowledgementRequest> var1);

    public B acknowledgementRequest(AcknowledgementRequest var1, AcknowledgementRequest ... var2);

    public B timeout(@Nullable CharSequence var1);

    public B timeout(@Nullable Duration var1);

    public B putMetadata(MetadataHeaderKey var1, JsonValue var2);

    public B allowPolicyLockout(boolean var1);

    public B journalTags(Collection<String> var1);

    public B putHeader(CharSequence var1, CharSequence var2);

    public B putHeaders(Map<String, String> var1);

    public B removeHeader(CharSequence var1);

    public B removePreconditionHeaders();

    public R build();
}

