/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoHeadersTooLargeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;

@Immutable
public final class DittoHeadersSizeChecker {
    private final long maxSize;
    private final int maxAuthSubjects;

    private DittoHeadersSizeChecker(long maxSize, int maxAuthSubjects) {
        this.maxSize = maxSize;
        this.maxAuthSubjects = maxAuthSubjects;
    }

    public static DittoHeadersSizeChecker of(long maxSize, int maxAuthSubjects) {
        return new DittoHeadersSizeChecker(maxSize, maxAuthSubjects);
    }

    public void check(DittoHeaders dittoHeaders) {
        ConditionChecker.checkNotNull(dittoHeaders, "DittoHeaders to be checked");
        this.checkAuthorizationContext(dittoHeaders);
        if (dittoHeaders.isEntriesSizeGreaterThan(this.maxSize)) {
            throw DittoHeadersTooLargeException.newSizeLimitBuilder(this.maxSize).dittoHeaders(dittoHeaders).build();
        }
    }

    private void checkAuthorizationContext(DittoHeaders dittoHeaders) {
        AuthorizationContext authorizationContext = dittoHeaders.getAuthorizationContext();
        int authSubjectsCount = authorizationContext.getSize();
        if (authSubjectsCount > this.maxAuthSubjects * 2) {
            throw DittoHeadersTooLargeException.newAuthSubjectsLimitBuilder(authSubjectsCount, this.maxAuthSubjects).dittoHeaders(dittoHeaders).build();
        }
    }
}

