/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatcher;

@Immutable
final class EntityTagMatcherValueValidator
extends AbstractHeaderValueValidator {
    private EntityTagMatcherValueValidator(Predicate<Class<?>> valueTypePredicate) {
        super(valueTypePredicate);
    }

    static EntityTagMatcherValueValidator getInstance() {
        return EntityTagMatcherValueValidator.getInstance(EntityTagMatcher.class::equals);
    }

    static EntityTagMatcherValueValidator getInstance(Predicate<Class<?>> valueTypePredicate) {
        return new EntityTagMatcherValueValidator(valueTypePredicate);
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        if (!EntityTagMatcher.isValid(value)) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "entity-tag").href("https://tools.ietf.org/html/rfc7232#section-2.3").build();
        }
    }
}

