/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.ValueValidator;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatchers;

@Immutable
final class EntityTagMatchersValueValidator
extends AbstractHeaderValueValidator {
    private final ValueValidator entityTagMatcherValueValidator;

    private EntityTagMatchersValueValidator(ValueValidator entityTagMatcherValueValidator) {
        super(EntityTagMatchers.class::equals);
        this.entityTagMatcherValueValidator = entityTagMatcherValueValidator;
    }

    static EntityTagMatchersValueValidator getInstance(ValueValidator entityTagMatcherValueValidator) {
        ConditionChecker.checkNotNull(entityTagMatcherValueValidator, "entityTagMatcherValueValidator");
        return new EntityTagMatchersValueValidator(entityTagMatcherValueValidator);
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        String[] entityTagMatchers;
        for (String entityTagMatcher : entityTagMatchers = EntityTagMatchers.ENTITY_TAG_MATCHERS_PATTERN.split(String.valueOf(value))) {
            this.entityTagMatcherValueValidator.accept(definition, entityTagMatcher);
        }
    }
}

