/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class Header
implements CharSequence {
    private final String key;
    private final String value;

    private Header(String key, String value) {
        this.key = key;
        this.value = value;
    }

    static Header of(String key, String value) {
        return new Header(key, value);
    }

    String getKey() {
        return this.key;
    }

    String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return Objects.equals(this.value, other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public char charAt(int i) {
        return this.value.charAt(i);
    }

    @Override
    public Header subSequence(int i, int j) {
        return new Header(this.key, this.value.substring(i, j));
    }
}

