/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class JsonObjectValueValidator
extends AbstractHeaderValueValidator {
    private static final JsonObjectValueValidator INSTANCE = new JsonObjectValueValidator();

    private JsonObjectValueValidator() {
        super(JsonObject.class::equals);
    }

    static JsonObjectValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        JsonObjectValueValidator.tryToParseJsonObject(definition, value.toString());
    }

    private static JsonObject tryToParseJsonObject(HeaderDefinition definition, String value) {
        try {
            return JsonObject.of((String)value);
        }
        catch (JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, (CharSequence)value, "JSON object").build();
        }
    }
}

