/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class LongValueValidator
extends AbstractHeaderValueValidator {
    private static final LongValueValidator INSTANCE = new LongValueValidator();

    private LongValueValidator() {
        super(valueType -> Long.TYPE.equals(valueType) || Long.class.equals(valueType));
    }

    static LongValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "long").build();
        }
    }
}

