/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaders;

@Immutable
final class MetadataHeadersValueValidator
extends AbstractHeaderValueValidator {
    private MetadataHeadersValueValidator() {
        super(JsonArray.class::equals);
    }

    static MetadataHeadersValueValidator getInstance() {
        return new MetadataHeadersValueValidator();
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            MetadataHeaders.parseMetadataHeaders(value);
        }
        catch (JsonMissingFieldException | JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "MetadataHeaders").description(MetadataHeadersValueValidator.getDescription((JsonRuntimeException)e)).cause(e).build();
        }
    }

    private static String getDescription(JsonRuntimeException jsonRuntimeException) {
        String message = jsonRuntimeException.getMessage();
        return jsonRuntimeException.getDescription().map(description -> message + " " + description).orElse(message);
    }
}

