/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class NonEmptyValueValidator
extends AbstractHeaderValueValidator {
    private static final String MESSAGE_TEMPLATE = "The value of the header ''{0}'' must not be empty.";
    private static final NonEmptyValueValidator INSTANCE = new NonEmptyValueValidator();

    private NonEmptyValueValidator() {
        super(CharSequence.class::isAssignableFrom);
    }

    static NonEmptyValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        if (value.length() < 1) {
            String message = MessageFormat.format(MESSAGE_TEMPLATE, definition.getKey());
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newCustomMessageBuilder(message).build();
        }
    }
}

