/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabelInvalidException;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class RequestedAcksValueValidator
extends AbstractHeaderValueValidator {
    private static final RequestedAcksValueValidator INSTANCE = new RequestedAcksValueValidator();

    private RequestedAcksValueValidator() {
        super(JsonArray.class::equals);
    }

    static RequestedAcksValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        JsonArray jsonArray;
        try {
            jsonArray = JsonArray.of((String)value.toString());
        }
        catch (JsonParseException e) {
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "JSON array").build();
        }
        for (JsonValue jsonValue : jsonArray) {
            if (jsonValue.isString()) {
                try {
                    AcknowledgementLabel.of(jsonValue.asString());
                    continue;
                }
                catch (AcknowledgementLabelInvalidException e) {
                    throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newInvalidTypeBuilder(definition, value, "JSON array of acknowledgement labels").cause(e).build();
                }
            }
            String msgTemplate = "JSON array for <{0}> contained invalid acknowledgement labels.";
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newCustomMessageBuilder(MessageFormat.format("JSON array for <{0}> contained invalid acknowledgement labels.", definition.getKey())).build();
        }
    }
}

