/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.DittoDuration;
import org.eclipse.ditto.model.base.exceptions.TimeoutInvalidException;
import org.eclipse.ditto.model.base.headers.AbstractHeaderValueValidator;
import org.eclipse.ditto.model.base.headers.HeaderDefinition;

@Immutable
final class TimeoutValueValidator
extends AbstractHeaderValueValidator {
    private static final TimeoutValueValidator INSTANCE = new TimeoutValueValidator();

    private TimeoutValueValidator() {
        super(DittoDuration.class::equals);
    }

    static TimeoutValueValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void validateValue(HeaderDefinition definition, CharSequence value) {
        try {
            DittoDuration.parseDuration(value);
        }
        catch (IllegalArgumentException e) {
            throw (TimeoutInvalidException)TimeoutInvalidException.newBuilder(e.getMessage()).build();
        }
    }
}

